/*
 * Decompiled with CFR 0.152.
 */
package de.redstoneworld.redaction;

import com.google.common.collect.Sets;
import de.redstoneworld.redaction.ClickType;
import de.redstoneworld.redutilities.material.MaterialHelper;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;

public class Action {
    private final String name;
    private final Map<Material, BlockData> clickedBlocks = new EnumMap<Material, BlockData>(Material.class);
    private final BlockFace blockDirection;
    private final EntityType clickedEntity;
    private final Boolean isClickedEntityBaby;
    private final Set<Material> handItems = EnumSet.noneOf(Material.class);
    private final int handDamage;
    private final Set<Material> offhandItems = EnumSet.noneOf(Material.class);
    private final int offhandDamage;
    private final List<String> commands;
    private final List<String> commandPermissions;
    private final boolean commandsAsOperator;
    private final boolean commandsAsConsole;
    private final boolean outputShown;
    private final ClickType click;
    private final boolean cancel;
    private final Boolean sneaking;
    private final Boolean cancelled;

    public Action(String name, ConfigurationSection config) throws IllegalArgumentException {
        int n;
        this.name = name;
        String blockData = config.getString("states", config.getString("block-data", ""));
        if (config.contains("clicked-block", true)) {
            for (Material material : Action.getMaterials(config.getString("clicked-block", "NULL"))) {
                this.clickedBlocks.put(material, material.createBlockData(blockData));
            }
        }
        EntityType clickedEntity = null;
        if (config.contains("clicked-entity", true)) {
            clickedEntity = EntityType.valueOf((String)config.getString("clicked-entity", "NULL").toUpperCase());
        }
        this.isClickedEntityBaby = (Boolean)config.get("entity-is-baby", null);
        if (config.contains("hand-item", true)) {
            this.handItems.addAll(Action.getMaterials(config.getString("hand-item", "NULL")));
        }
        int n2 = config.getInt("hand-damage", config.getInt("hand-data", -1));
        if (config.contains("offhand-item", true)) {
            this.offhandItems.addAll(Action.getMaterials(config.getString("offhand-item", "NULL")));
        }
        int offhandDamage = config.getInt("offhand-damage", config.getInt("offhand-data", -1));
        if (config.contains("object", true)) {
            Material object = Material.valueOf((String)config.getString("object", "NULL").toUpperCase());
            String condition = config.getString("condition", null);
            if ("hand".equalsIgnoreCase(condition)) {
                this.handItems.add(object);
                n = config.getInt("damage", -1);
            } else if ("offhand".equalsIgnoreCase(condition)) {
                this.offhandItems.add(object);
                offhandDamage = config.getInt("damage", -1);
            } else if ("block".equalsIgnoreCase(condition)) {
                this.clickedBlocks.put(object, object.createBlockData());
                if (config.isSet("damage")) {
                    throw new IllegalArgumentException("Block damage values are no longer supported! Use the 'states' setting.");
                }
            }
        }
        this.clickedEntity = clickedEntity;
        this.handDamage = n;
        this.offhandDamage = offhandDamage;
        this.commands = config.getStringList("commands");
        this.commandPermissions = config.getStringList("command-permissions");
        this.commandsAsOperator = config.getBoolean("command-as-operator", true);
        this.commandsAsConsole = config.getBoolean("command-as-console", false);
        this.outputShown = config.getBoolean("output", true);
        this.click = config.contains("click", true) ? ClickType.valueOf(config.getString("click").toUpperCase()) : null;
        this.blockDirection = config.contains("direction", true) ? BlockFace.valueOf((String)config.getString("direction").toUpperCase()) : null;
        this.cancel = config.getBoolean("cancel", false);
        this.sneaking = (Boolean)config.get("sneaking", null);
        this.cancelled = (Boolean)config.get("cancelled", null);
    }

    private static Collection<? extends Material> getMaterials(String blockStr) {
        return MaterialHelper.getMaterials((Set)Sets.newHashSet((Object[])blockStr.split(",")));
    }

    public String getName() {
        return this.name;
    }

    public Map<Material, BlockData> getClickedBlocks() {
        return this.clickedBlocks;
    }

    public BlockFace getBlockDirection() {
        return this.blockDirection;
    }

    public EntityType getClickedEntity() {
        return this.clickedEntity;
    }

    public Boolean getIsClickedEntityBaby() {
        return this.isClickedEntityBaby;
    }

    public Set<Material> getHandItems() {
        return this.handItems;
    }

    public int getHandDamage() {
        return this.handDamage;
    }

    public Set<Material> getOffhandItems() {
        return this.offhandItems;
    }

    public int getOffhandDamage() {
        return this.offhandDamage;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<String> getCommandPermissions() {
        return this.commandPermissions;
    }

    public boolean isCommandsAsOperator() {
        return this.commandsAsOperator;
    }

    public boolean isCommandsAsConsole() {
        return this.commandsAsConsole;
    }

    public boolean isOutputShown() {
        return this.outputShown;
    }

    public ClickType getClick() {
        return this.click;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public Boolean getSneaking() {
        return this.sneaking;
    }

    public Boolean getCancelled() {
        return this.cancelled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action other = (Action)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHandDamage() != other.getHandDamage()) {
            return false;
        }
        if (this.getOffhandDamage() != other.getOffhandDamage()) {
            return false;
        }
        if (this.isCommandsAsOperator() != other.isCommandsAsOperator()) {
            return false;
        }
        if (this.isCommandsAsConsole() != other.isCommandsAsConsole()) {
            return false;
        }
        if (this.isOutputShown() != other.isOutputShown()) {
            return false;
        }
        if (this.isCancel() != other.isCancel()) {
            return false;
        }
        Boolean this$isClickedEntityBaby = this.getIsClickedEntityBaby();
        Boolean other$isClickedEntityBaby = other.getIsClickedEntityBaby();
        if (this$isClickedEntityBaby == null ? other$isClickedEntityBaby != null : !((Object)this$isClickedEntityBaby).equals(other$isClickedEntityBaby)) {
            return false;
        }
        Boolean this$sneaking = this.getSneaking();
        Boolean other$sneaking = other.getSneaking();
        if (this$sneaking == null ? other$sneaking != null : !((Object)this$sneaking).equals(other$sneaking)) {
            return false;
        }
        Boolean this$cancelled = this.getCancelled();
        Boolean other$cancelled = other.getCancelled();
        if (this$cancelled == null ? other$cancelled != null : !((Object)this$cancelled).equals(other$cancelled)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<Material, BlockData> this$clickedBlocks = this.getClickedBlocks();
        Map<Material, BlockData> other$clickedBlocks = other.getClickedBlocks();
        if (this$clickedBlocks == null ? other$clickedBlocks != null : !((Object)this$clickedBlocks).equals(other$clickedBlocks)) {
            return false;
        }
        BlockFace this$blockDirection = this.getBlockDirection();
        BlockFace other$blockDirection = other.getBlockDirection();
        if (this$blockDirection == null ? other$blockDirection != null : !this$blockDirection.equals(other$blockDirection)) {
            return false;
        }
        EntityType this$clickedEntity = this.getClickedEntity();
        EntityType other$clickedEntity = other.getClickedEntity();
        if (this$clickedEntity == null ? other$clickedEntity != null : !this$clickedEntity.equals(other$clickedEntity)) {
            return false;
        }
        Set<Material> this$handItems = this.getHandItems();
        Set<Material> other$handItems = other.getHandItems();
        if (this$handItems == null ? other$handItems != null : !((Object)this$handItems).equals(other$handItems)) {
            return false;
        }
        Set<Material> this$offhandItems = this.getOffhandItems();
        Set<Material> other$offhandItems = other.getOffhandItems();
        if (this$offhandItems == null ? other$offhandItems != null : !((Object)this$offhandItems).equals(other$offhandItems)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        List<String> this$commandPermissions = this.getCommandPermissions();
        List<String> other$commandPermissions = other.getCommandPermissions();
        if (this$commandPermissions == null ? other$commandPermissions != null : !((Object)this$commandPermissions).equals(other$commandPermissions)) {
            return false;
        }
        ClickType this$click = this.getClick();
        ClickType other$click = other.getClick();
        return !(this$click == null ? other$click != null : !((Object)((Object)this$click)).equals((Object)other$click));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Action;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHandDamage();
        result = result * 59 + this.getOffhandDamage();
        result = result * 59 + (this.isCommandsAsOperator() ? 79 : 97);
        result = result * 59 + (this.isCommandsAsConsole() ? 79 : 97);
        result = result * 59 + (this.isOutputShown() ? 79 : 97);
        result = result * 59 + (this.isCancel() ? 79 : 97);
        Boolean $isClickedEntityBaby = this.getIsClickedEntityBaby();
        result = result * 59 + ($isClickedEntityBaby == null ? 43 : ((Object)$isClickedEntityBaby).hashCode());
        Boolean $sneaking = this.getSneaking();
        result = result * 59 + ($sneaking == null ? 43 : ((Object)$sneaking).hashCode());
        Boolean $cancelled = this.getCancelled();
        result = result * 59 + ($cancelled == null ? 43 : ((Object)$cancelled).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<Material, BlockData> $clickedBlocks = this.getClickedBlocks();
        result = result * 59 + ($clickedBlocks == null ? 43 : ((Object)$clickedBlocks).hashCode());
        BlockFace $blockDirection = this.getBlockDirection();
        result = result * 59 + ($blockDirection == null ? 43 : $blockDirection.hashCode());
        EntityType $clickedEntity = this.getClickedEntity();
        result = result * 59 + ($clickedEntity == null ? 43 : $clickedEntity.hashCode());
        Set<Material> $handItems = this.getHandItems();
        result = result * 59 + ($handItems == null ? 43 : ((Object)$handItems).hashCode());
        Set<Material> $offhandItems = this.getOffhandItems();
        result = result * 59 + ($offhandItems == null ? 43 : ((Object)$offhandItems).hashCode());
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        List<String> $commandPermissions = this.getCommandPermissions();
        result = result * 59 + ($commandPermissions == null ? 43 : ((Object)$commandPermissions).hashCode());
        ClickType $click = this.getClick();
        result = result * 59 + ($click == null ? 43 : ((Object)((Object)$click)).hashCode());
        return result;
    }

    public String toString() {
        return "Action(name=" + this.getName() + ", clickedBlocks=" + String.valueOf(this.getClickedBlocks()) + ", blockDirection=" + String.valueOf(this.getBlockDirection()) + ", clickedEntity=" + String.valueOf(this.getClickedEntity()) + ", isClickedEntityBaby=" + this.getIsClickedEntityBaby() + ", handItems=" + String.valueOf(this.getHandItems()) + ", handDamage=" + this.getHandDamage() + ", offhandItems=" + String.valueOf(this.getOffhandItems()) + ", offhandDamage=" + this.getOffhandDamage() + ", commands=" + String.valueOf(this.getCommands()) + ", commandPermissions=" + String.valueOf(this.getCommandPermissions()) + ", commandsAsOperator=" + this.isCommandsAsOperator() + ", commandsAsConsole=" + this.isCommandsAsConsole() + ", outputShown=" + this.isOutputShown() + ", click=" + String.valueOf((Object)this.getClick()) + ", cancel=" + this.isCancel() + ", sneaking=" + this.getSneaking() + ", cancelled=" + this.getCancelled() + ")";
    }
}

