/*
 * Decompiled with CFR 0.152.
 */
package de.redstoneworld.redaction;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.redstoneworld.redaction.Action;
import de.redstoneworld.redaction.ActionListener;
import de.redstoneworld.redaction.ClickEventData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.GameRule;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class RedAction
extends JavaPlugin {
    private Cache<Integer, List<Action>> cancelActionCache;
    private Cache<Integer, List<Action>> noCancelActionCache;
    private List<Action> actions;
    private boolean debug;

    public void onEnable() {
        this.loadConfig();
        this.getCommand("redaction").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ActionListener(this), (Plugin)this);
    }

    public void loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.debug = this.getConfig().getBoolean("debug");
        this.cancelActionCache = this.getConfig().getInt("expire-durations.cancel-cache") > 0 ? CacheBuilder.newBuilder().expireAfterAccess((long)this.getConfig().getInt("expire-durations.cancel-cache"), TimeUnit.MINUTES).build() : null;
        this.noCancelActionCache = this.getConfig().getInt("expire-durations.no-cancel-cache") > 0 ? CacheBuilder.newBuilder().expireAfterAccess((long)this.getConfig().getInt("expire-durations.no-cancel-cache"), TimeUnit.MINUTES).build() : null;
        this.actions = new ArrayList<Action>();
        ConfigurationSection actionSection = this.getConfig().getConfigurationSection("actions");
        for (String actionName : actionSection.getKeys(false)) {
            try {
                this.registerAction(new Action(actionName, actionSection.getConfigurationSection(actionName)));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.WARNING, "Action " + actionName + " has an invalid config! " + e.getMessage());
            }
        }
        this.getLogger().log(Level.INFO, "Registered " + this.actions.size() + " actions!");
    }

    private void registerAction(Action action) {
        this.actions.add(action);
        try {
            this.getServer().getPluginManager().addPermission(new Permission("rwm.redaction.actions." + action.getName().toLowerCase(), PermissionDefault.FALSE));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.logDebug("Registered " + String.valueOf(action));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length > 0 && "reload".equalsIgnoreCase(args[0]) && sender.hasPermission("rwm.redaction.command.reload")) {
            this.loadConfig();
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Config reloaded!");
            return true;
        }
        return false;
    }

    public List<Action> getCachedActions(ClickEventData data, boolean cancelActions) {
        Cache<Integer, List<Action>> cache;
        Cache<Integer, List<Action>> cache2 = cache = cancelActions ? this.cancelActionCache : this.noCancelActionCache;
        if (cache != null) {
            return (List)cache.getIfPresent((Object)data.hashCode());
        }
        return null;
    }

    public List<Action> getActions(ClickEventData data, boolean cancelActions) {
        ArrayList<Action> actionList;
        Cache<Integer, List<Action>> cache;
        Cache<Integer, List<Action>> cache2 = cache = cancelActions ? this.cancelActionCache : this.noCancelActionCache;
        if (cache != null && (actionList = (List)cache.getIfPresent((Object)data.hashCode())) != null) {
            return actionList;
        }
        actionList = new ArrayList();
        for (Action action : this.actions) {
            if (action == null || action.isCancel() != cancelActions || action.getClick() != null && action.getClick() != data.getClick() || !action.getClickedBlocks().isEmpty() && !action.getClickedBlocks().containsKey(data.getClickedMaterial()) || action.getClickedEntity() != null && action.getClickedEntity() != data.getEntityType() || action.getClickedEntity() != null && data.getEntityType() != null && action.getIsClickedEntityBaby() != null && action.getIsClickedEntityBaby() != data.getIsBaby() || !action.getHandItems().isEmpty() && !action.getHandItems().contains(data.getHandItem()) || !action.getOffhandItems().isEmpty() && !action.getOffhandItems().contains(data.getOffhandItem()) || data.getHandDamage() != -1 && action.getHandDamage() >= 0 && action.getHandDamage() != data.getHandDamage() || data.getOffhandDamage() != -1 && action.getOffhandDamage() >= 0 && action.getOffhandDamage() != data.getOffhandDamage() || action.getBlockDirection() != null && action.getBlockDirection() != data.getClickedDirection() || action.getSneaking() != null && action.getSneaking().booleanValue() != data.isSneaking() || action.getCancelled() != null && action.getCancelled().booleanValue() != data.isCancelled() || data.getClickedData() != null && !action.getClickedBlocks().isEmpty() && !data.getClickedData().matches(action.getClickedBlocks().get(data.getClickedMaterial()))) continue;
            actionList.add(action);
        }
        if (cache != null) {
            cache.put((Object)data.hashCode(), actionList);
        }
        return actionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Action action, Player player, Map<String, String> replacements) {
        Boolean sendCommandFeedback;
        PermissionAttachment perm;
        block6: {
            this.logDebug(player.getName() + " executes " + String.valueOf(action));
            boolean wasOp = player.isOp();
            perm = player.addAttachment((Plugin)this);
            for (String commandPerm : action.getCommandPermissions()) {
                perm.setPermission(this.replaceReplacements(commandPerm, replacements), !commandPerm.startsWith("-") && !commandPerm.startsWith("!"));
            }
            sendCommandFeedback = (Boolean)player.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK);
            try {
                if (action.isCommandsAsOperator() && !wasOp) {
                    player.setOp(true);
                }
                player.getWorld().setGameRule(GameRule.SEND_COMMAND_FEEDBACK, (Object)action.isOutputShown());
                for (String command : action.getCommands()) {
                    player.getServer().dispatchCommand((CommandSender)(action.isCommandsAsConsole() ? this.getServer().getConsoleSender() : player), this.replaceReplacements(command, replacements));
                }
                if (!action.isCommandsAsOperator() || wasOp) break block6;
            }
            catch (Throwable throwable) {
                if (action.isCommandsAsOperator() && !wasOp) {
                    player.setOp(false);
                }
                player.removeAttachment(perm);
                player.getWorld().setGameRule(GameRule.SEND_COMMAND_FEEDBACK, (Object)(sendCommandFeedback != null ? sendCommandFeedback : true));
                throw throwable;
            }
            player.setOp(false);
        }
        player.removeAttachment(perm);
        player.getWorld().setGameRule(GameRule.SEND_COMMAND_FEEDBACK, (Object)(sendCommandFeedback != null ? sendCommandFeedback : true));
    }

    private String replaceReplacements(String string, Map<String, String> replacements) {
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            string = string.replace("%" + replacement.getKey() + "%", replacement.getValue());
        }
        return string;
    }

    private void logDebug(String message) {
        if (this.debug) {
            this.getLogger().log(Level.INFO, "Debug: " + message);
        }
    }
}

