/*
 * Decompiled with CFR 0.152.
 */
package de.redstoneworld.redplayerinfo.bukkit;

import de.redstoneworld.redplayerinfo.bukkit.RedPlayerInfoBukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerListener
implements Listener {
    private final RedPlayerInfoBukkit plugin;

    public PlayerListener(RedPlayerInfoBukkit plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        this.plugin.removePlayer(event.getPlayer());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.plugin.updateLastActivity(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (event.getPlayer() instanceof Player) {
            this.plugin.updateLastActivity((Player)event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            this.plugin.updateLastActivity((Player)event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryInteract(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            this.plugin.updateLastActivity((Player)event.getWhoClicked());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        this.plugin.updateLastActivity(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        this.plugin.updateLastActivity(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.PHYSICAL) {
            this.plugin.updateLastActivity(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlock() != event.getTo().getBlock()) {
            this.plugin.updateLastActivity(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent event) {
        if (event.getFrom() != event.getTo()) {
            this.plugin.updateLastActivity(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        this.plugin.updateLastActivity(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        this.plugin.updateLastActivity(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onChat(AsyncPlayerChatEvent event) {
        this.plugin.updateLastActivity(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            this.plugin.updateLastActivity((Player)event.getEntity());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            this.plugin.updateLastActivity((Player)event.getDamager());
        }
    }
}

