/*
 * Decompiled with CFR 0.152.
 */
package de.redstoneworld.redplayerinfo.bukkit;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.redstoneworld.redplayerinfo.bukkit.PlayerListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class RedPlayerInfoBukkit
extends JavaPlugin {
    private static final String PLUGIN_MESSAGE_CHANNEL = "rpi:";
    private Map<UUID, Long> lastActivity = new HashMap<UUID, Long>();
    private Map<UUID, Boolean> afkPlayers = new HashMap<UUID, Boolean>();

    public void onEnable() {
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "rpi:unsetafk");
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "rpi:afktime");
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "rpi:setafk", (channel, player, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
            UUID playerId = new UUID(in.readLong(), in.readLong());
            if (this.isReal(playerId)) {
                this.afkPlayers.put(playerId, in.readBoolean());
            }
        });
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "rpi:unsetafk", (channel, player, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
            UUID playerId = new UUID(in.readLong(), in.readLong());
            if (this.isReal(playerId)) {
                this.afkPlayers.remove(playerId);
            }
        });
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, this::updateStatus, 1200L, 200L);
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.lastActivity.clear();
        this.lastActivity = null;
    }

    public void updateLastActivity(Player player) {
        if (this.isReal(player.getUniqueId())) {
            this.lastActivity.put(player.getUniqueId(), System.currentTimeMillis());
            if (this.isAfk(player.getUniqueId())) {
                this.unsetAfk(player);
            }
        }
    }

    private boolean isReal(UUID playerId) {
        return playerId.version() == 3 || playerId.version() == 4;
    }

    private void unsetAfk(Player player) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeBoolean(!this.isAutoAfk(player.getUniqueId()));
        player.sendPluginMessage((Plugin)this, "rpi:unsetafk", out.toByteArray());
        this.afkPlayers.remove(player.getUniqueId());
    }

    public boolean isAfk(UUID playerId) {
        return this.afkPlayers.containsKey(playerId);
    }

    public boolean isAutoAfk(UUID playerId) {
        return this.isAfk(playerId) && this.afkPlayers.get(playerId) == false;
    }

    public long getLastActivity(Player player) {
        if (this.lastActivity.containsKey(player.getUniqueId())) {
            return this.lastActivity.get(player.getUniqueId());
        }
        return -1L;
    }

    public void removePlayer(Player player) {
        this.lastActivity.remove(player.getUniqueId());
        this.afkPlayers.remove(player.getUniqueId());
    }

    private void updateStatus() {
        if (!this.getServer().getOnlinePlayers().isEmpty() && this.lastActivity.size() - this.afkPlayers.size() > 0) {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeInt(this.lastActivity.size() - this.afkPlayers.size());
            for (Map.Entry<UUID, Long> entry : this.lastActivity.entrySet()) {
                if (this.isAfk(entry.getKey())) continue;
                out.writeLong(entry.getKey().getMostSignificantBits());
                out.writeLong(entry.getKey().getLeastSignificantBits());
                out.writeInt((int)((System.currentTimeMillis() - entry.getValue()) / 1000L));
            }
            Iterator playerIterator = this.getServer().getOnlinePlayers().iterator();
            Player player = (Player)playerIterator.next();
            while (!this.isReal(player.getUniqueId()) && playerIterator.hasNext()) {
                player = (Player)playerIterator.next();
            }
            if (this.isReal(player.getUniqueId())) {
                player.sendPluginMessage((Plugin)this, "rpi:afktime", out.toByteArray());
            } else {
                this.getLogger().log(Level.WARNING, "Could not send plugin message as no real player was found?");
            }
        }
    }
}

