/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.BungeeResourcepacks.bungee;

import de.themoep.BungeeResourcepacks.bungee.BungeeResouecepacksCommand;
import de.themoep.BungeeResourcepacks.bungee.YamlConfig;
import de.themoep.BungeeResourcepacks.bungee.listeners.PlayerDisconnectListener;
import de.themoep.BungeeResourcepacks.bungee.listeners.ServerConnectedListener;
import de.themoep.BungeeResourcepacks.bungee.packets.ResourcePackSendPacket;
import de.themoep.BungeeResourcepacks.core.PackManager;
import de.themoep.BungeeResourcepacks.core.ResourcePack;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;

public class BungeeResourcepacks
extends Plugin {
    private YamlConfig config;
    private PackManager pm;
    public Level loglevel;
    private Map<UUID, Boolean> joiningplayers = new ConcurrentHashMap<UUID, Boolean>();
    public boolean enabled = false;

    public void onEnable() {
        this.getProxy().getPluginManager().registerCommand((Plugin)BungeeResourcepacks.getInstance(), (Command)new BungeeResouecepacksCommand(this, "bungeeresourcepacks", "bungeeresourcepacks.command", "brp"));
        try {
            Method reg = Protocol.DirectionData.class.getDeclaredMethod("registerPacket", Integer.TYPE, Class.class);
            reg.setAccessible(true);
            try {
                reg.invoke((Object)Protocol.GAME.TO_CLIENT, 72, ResourcePackSendPacket.class);
                this.enabled = this.loadConfig();
                this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ServerConnectedListener());
                this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PlayerDisconnectListener());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchMethodException e) {
            this.getLogger().log(Level.SEVERE, "Couldn't find the registerPacket method in the Protocol.DirectionData class! Please update this plugin or downgrade BungeeCord!");
            e.printStackTrace();
        }
    }

    public boolean loadConfig() {
        String globalpackname;
        try {
            this.config = new YamlConfig(this.getDataFolder() + File.separator + "config.yml");
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to load configuration! BungeeResourcepacks will not be enabled!");
            e.printStackTrace();
            return false;
        }
        this.loglevel = this.getConfig().getString("debug", "true").equalsIgnoreCase("true") ? Level.INFO : Level.FINE;
        this.pm = new PackManager();
        Configuration packs = this.getConfig().getSection("packs");
        for (String s : packs.getKeys()) {
            this.pm.addPack(new ResourcePack(s.toLowerCase(), packs.getString(s + ".url"), packs.getString(s + ".hash")));
        }
        String emptypackname = this.getConfig().getString("empty");
        if (emptypackname != null) {
            ResourcePack ep = this.pm.getByName(emptypackname);
            if (ep != null) {
                this.pm.setEmptyPack(ep);
            } else {
                this.getLogger().warning("Cannot set empty resourcepack as there is no pack with the name " + emptypackname + " defined!");
            }
        }
        if ((globalpackname = this.getConfig().getString("global.pack")) != null) {
            ResourcePack gp = this.pm.getByName(globalpackname);
            if (gp != null) {
                this.pm.setGlobalPack(gp);
            } else {
                this.getLogger().warning("Cannot set global resourcepack as there is no pack with the name " + globalpackname + " defined!");
            }
        }
        Configuration servers = this.getConfig().getSection("servers");
        for (String s : servers.getKeys()) {
            String packname = servers.getString(s + ".pack");
            if (packname != null) {
                ResourcePack sp = this.pm.getByName(packname);
                if (sp != null) {
                    this.pm.addServer(s, sp);
                    continue;
                }
                this.getLogger().warning("Cannot set resourcepack for " + s + " as there is no pack with the name " + packname + " defined!");
                continue;
            }
            this.getLogger().warning("Cannot find a pack setting for " + s + "! Please make sure you have a pack node on servers." + s + "!");
        }
        return true;
    }

    public void reloadConfig() {
        this.loadConfig();
        if (this.enabled) {
            this.getLogger().log(Level.INFO, "Reloaded config. Resending packs for all online players!");
            for (ProxiedPlayer p : this.getProxy().getPlayers()) {
                this.resendPack(p);
            }
        }
    }

    public static BungeeResourcepacks getInstance() {
        return (BungeeResourcepacks)ProxyServer.getInstance().getPluginManager().getPlugin("BungeeResourcepacks");
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public void resendPack(ProxiedPlayer player) {
        ResourcePack pack = null;
        Server server = player.getServer();
        if (server != null) {
            pack = this.getPackManager().getServerPack(server.getInfo().getName());
        }
        if (pack == null) {
            pack = this.getPackManager().getGlobalPack();
        }
        if (pack != null) {
            this.setPack(player, pack);
        }
    }

    public void setPack(ProxiedPlayer player, ResourcePack pack) {
        player.unsafe().sendPacket((DefinedPacket)new ResourcePackSendPacket(pack));
        this.getPackManager().setUserPack(player.getUniqueId(), pack);
        BungeeResourcepacks.getInstance().getLogger().log(this.loglevel, "Send pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getName());
    }

    public PackManager getPackManager() {
        return this.pm;
    }

    public void setJoining(UUID playerid) {
        this.joiningplayers.put(playerid, false);
    }

    public void unsetJoining(UUID playerid) {
        this.joiningplayers.remove(playerid);
    }

    public boolean isJoining(UUID playerid) {
        return this.joiningplayers.containsKey(playerid);
    }
}

