/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.BungeeResourcepacks.core;

import de.themoep.BungeeResourcepacks.core.ResourcePack;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PackManager {
    private Map<String, ResourcePack> packmap = new HashMap<String, ResourcePack>();
    private Map<String, String> hashmap = new HashMap<String, String>();
    private Map<String, String> urlmap = new HashMap<String, String>();
    private Map<UUID, String> usermap = new ConcurrentHashMap<UUID, String>();
    private ResourcePack empty = null;
    private ResourcePack global = null;
    private Map<String, String> servermap = new HashMap<String, String>();

    public ResourcePack addPack(ResourcePack pack) {
        this.hashmap.put(pack.getHash(), pack.getName().toLowerCase());
        this.urlmap.put(pack.getUrl(), pack.getName().toLowerCase());
        return this.packmap.put(pack.getName().toLowerCase(), pack);
    }

    public ResourcePack getByName(String name) {
        return this.packmap.get(name.toLowerCase());
    }

    public ResourcePack getByHash(String hash) {
        String name = this.hashmap.get(hash);
        return name == null ? null : this.getByName(name);
    }

    public ResourcePack getByUrl(String url) {
        String name = this.urlmap.get(url);
        return name == null ? null : this.getByName(name);
    }

    public ResourcePack setEmptyPack(ResourcePack pack) {
        ResourcePack rp = this.getEmptyPack();
        this.empty = pack;
        return rp;
    }

    public ResourcePack setEmptyPack(String packname) {
        return this.setEmptyPack(this.getByName(packname));
    }

    public ResourcePack getEmptyPack() {
        return this.empty;
    }

    public ResourcePack setGlobalPack(ResourcePack pack) {
        ResourcePack rp = this.getGlobalPack();
        this.global = pack;
        return rp;
    }

    public ResourcePack setGlobalPack(String packname) {
        return this.setGlobalPack(this.getByName(packname));
    }

    public ResourcePack getGlobalPack() {
        return this.global;
    }

    public ResourcePack getServerPack(String server) {
        String name = this.servermap.get(server);
        return name == null ? null : this.getByName(name);
    }

    public ResourcePack getUserPack(UUID playerid) {
        String name = this.usermap.get(playerid);
        return name == null ? null : this.getByName(name);
    }

    public ResourcePack setUserPack(UUID playerid, ResourcePack pack) {
        String previous = this.usermap.put(playerid, pack.getName());
        return previous == null ? null : this.getByName(previous);
    }

    public ResourcePack clearUserPack(UUID playerid) {
        String previous = this.usermap.remove(playerid);
        return previous == null ? null : this.getByName(previous);
    }

    public void addServer(String server, ResourcePack pack) {
        pack.addServer(server);
        this.servermap.put(server, pack.getName().toLowerCase());
    }

    public boolean removeServer(String server) {
        String packname = this.servermap.remove(server);
        if (packname != null && this.packmap.containsKey(packname)) {
            return this.packmap.get(packname).removeServer(server);
        }
        return false;
    }
}

