/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.BungeeResourcepacks.bungee;

import de.themoep.BungeeResourcepacks.bungee.BungeeResouecepacksCommand;
import de.themoep.BungeeResourcepacks.bungee.UsePackCommand;
import de.themoep.BungeeResourcepacks.bungee.YamlConfig;
import de.themoep.BungeeResourcepacks.bungee.listeners.DisconnectListener;
import de.themoep.BungeeResourcepacks.bungee.listeners.ServerSwitchListener;
import de.themoep.BungeeResourcepacks.bungee.packets.ResourcePackSendPacket;
import de.themoep.BungeeResourcepacks.core.PackManager;
import de.themoep.BungeeResourcepacks.core.ResourcePack;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;

public class BungeeResourcepacks
extends Plugin {
    private static BungeeResourcepacks instance;
    private YamlConfig config;
    private PackManager pm;
    public Level loglevel;
    private Map<UUID, Boolean> backendPackedPlayers = new ConcurrentHashMap<UUID, Boolean>();
    private boolean enabled = false;

    public void onEnable() {
        instance = this;
        this.getProxy().getPluginManager().registerCommand((Plugin)BungeeResourcepacks.getInstance(), (Command)new BungeeResouecepacksCommand(this, this.getDescription().getName().toLowerCase().charAt(0) + "rp", this.getDescription().getName().toLowerCase() + ".command", this.getDescription().getName().toLowerCase()));
        this.getProxy().getPluginManager().registerCommand((Plugin)BungeeResourcepacks.getInstance(), (Command)new UsePackCommand(this, "usepack", this.getDescription().getName().toLowerCase() + ".command.usepack", new String[0]));
        try {
            Method reg = Protocol.DirectionData.class.getDeclaredMethod("registerPacket", Integer.TYPE, Class.class);
            reg.setAccessible(true);
            try {
                reg.invoke((Object)Protocol.GAME.TO_CLIENT, 72, ResourcePackSendPacket.class);
                boolean loadingSuccessful = this.loadConfig();
                this.setEnabled(loadingSuccessful);
                this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new DisconnectListener(this));
                this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ServerSwitchListener(this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchMethodException e) {
            this.getLogger().log(Level.SEVERE, "Couldn't find the registerPacket method in the Protocol.DirectionData class! Please update this plugin or downgrade BungeeCord!");
            e.printStackTrace();
        }
    }

    public boolean loadConfig() {
        List<String> globalsecondary;
        String globalpackname;
        try {
            this.config = new YamlConfig(this, this.getDataFolder() + File.separator + "config.yml");
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to load configuration! " + this.getDescription().getName() + " will not be enabled!");
            e.printStackTrace();
            return false;
        }
        this.loglevel = this.getConfig().getString("debug", "true").equalsIgnoreCase("true") ? Level.INFO : Level.FINE;
        this.pm = new PackManager();
        Configuration packs = this.getConfig().getSection("packs");
        for (String s : packs.getKeys()) {
            this.getPackManager().addPack(new ResourcePack(s.toLowerCase(), packs.getString(s + ".url"), packs.getString(s + ".hash")));
        }
        String emptypackname = this.getConfig().getString("empty");
        if (emptypackname != null && !emptypackname.isEmpty()) {
            ResourcePack ep = this.getPackManager().getByName(emptypackname);
            if (ep != null) {
                this.getPackManager().setEmptyPack(ep);
            } else {
                this.getLogger().warning("Cannot set empty resourcepack as there is no pack with the name " + emptypackname + " defined!");
            }
        }
        if ((globalpackname = this.getConfig().getString("global.pack")) != null && !globalpackname.isEmpty()) {
            ResourcePack gp = this.getPackManager().getByName(globalpackname);
            if (gp != null) {
                this.getPackManager().setGlobalPack(gp);
            } else {
                this.getLogger().warning("Cannot set global resourcepack as there is no pack with the name " + globalpackname + " defined!");
            }
        }
        if ((globalsecondary = this.getConfig().getStringList("global.secondary")) != null) {
            for (String secondarypack : globalsecondary) {
                ResourcePack sp = this.getPackManager().getByName(secondarypack);
                if (sp != null) {
                    this.getPackManager().addGlobalSecondary(sp);
                    continue;
                }
                this.getLogger().warning("Cannot add resourcepack as a global secondaray pack as there is no pack with the name " + secondarypack + " defined!");
            }
        }
        Configuration servers = this.getConfig().getSection("servers");
        for (String s : servers.getKeys()) {
            List<String> serversecondary;
            String packname = servers.getString(s + ".pack");
            if (packname != null && !packname.isEmpty()) {
                ResourcePack sp = this.getPackManager().getByName(packname);
                if (sp != null) {
                    this.getPackManager().addServer(s, sp);
                } else {
                    this.getLogger().warning("Cannot set resourcepack for " + s + " as there is no pack with the name " + packname + " defined!");
                }
            } else {
                this.getLogger().warning("Cannot find a pack setting for " + s + "! Please make sure you have a pack node on servers." + s + "!");
            }
            if ((serversecondary = this.getConfig().getStringList(s + ".secondary")) == null) continue;
            for (String secondarypack : serversecondary) {
                ResourcePack sp = this.getPackManager().getByName(s);
                if (sp != null) {
                    this.getPackManager().addGlobalSecondary(sp);
                    continue;
                }
                this.getLogger().warning("Cannot add resourcepack as a secondary pack for server " + s + " as there is no pack with the name " + secondarypack + " defined!");
            }
        }
        return true;
    }

    public void reloadConfig(boolean resend) {
        this.loadConfig();
        this.getLogger().log(Level.INFO, "Reloaded config.");
        if (this.isEnabled() && resend) {
            this.getLogger().log(Level.INFO, "Resending packs for all online players!");
            for (ProxiedPlayer p : this.getProxy().getPlayers()) {
                this.resendPack(p);
            }
        }
    }

    public static BungeeResourcepacks getInstance() {
        return instance;
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void resendPack(ProxiedPlayer player) {
        ResourcePack pack = null;
        Server server = player.getServer();
        if (server != null) {
            pack = this.getPackManager().getServerPack(server.getInfo().getName());
        }
        if (pack == null) {
            pack = this.getPackManager().getGlobalPack();
        }
        if (pack != null) {
            this.setPack(player, pack);
        }
    }

    public void setPack(ProxiedPlayer player, ResourcePack pack) {
        int clientVersion = player.getPendingConnection().getVersion();
        if (clientVersion >= 47) {
            player.unsafe().sendPacket((DefinedPacket)new ResourcePackSendPacket(pack.getUrl(), pack.getHash()));
            this.getPackManager().setUserPack(player.getUniqueId(), pack);
            this.getLogger().log(this.loglevel, "Send pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getName());
        } else {
            this.getLogger().log(Level.WARNING, "Cannot send the pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getName() + " as he uses the unsupported protocol version " + clientVersion + "!");
            this.getLogger().log(Level.WARNING, "Consider blocking access to your server for clients below 1.8 if you want this plugin to work for everyone!");
        }
    }

    public void clearPack(ProxiedPlayer player) {
        this.getPackManager().clearUserPack(player.getUniqueId());
    }

    public PackManager getPackManager() {
        return this.pm;
    }

    public void setBackend(UUID playerid) {
        this.backendPackedPlayers.put(playerid, false);
    }

    public void unsetBackend(UUID playerid) {
        this.backendPackedPlayers.remove(playerid);
    }

    public boolean hasBackend(UUID playerid) {
        return this.backendPackedPlayers.containsKey(playerid);
    }
}

