/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.BungeeResourcepacks.bungee;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlConfig {
    protected Configuration cfg;
    protected static final ConfigurationProvider ymlCfg = ConfigurationProvider.getProvider(YamlConfiguration.class);
    protected File configFile;
    private Plugin plugin;

    public YamlConfig(Plugin plugin, String configFilePath) throws IOException {
        this.plugin = plugin;
        this.configFile = new File(configFilePath);
        if (!this.configFile.exists()) {
            if (!this.configFile.getParentFile().exists()) {
                this.configFile.getParentFile().mkdirs();
            }
            this.configFile.createNewFile();
            this.cfg = ymlCfg.load(this.configFile);
            this.createDefaultConfig();
        } else {
            this.cfg = ymlCfg.load(this.configFile);
        }
    }

    public void save() {
        try {
            ymlCfg.save(this.cfg, this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Unable to save configuration at " + this.configFile.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public void createDefaultConfig() {
        this.cfg = ymlCfg.load((Reader)new InputStreamReader(this.plugin.getResourceAsStream("config.yml")));
        this.save();
    }

    public void removeConfig() {
        this.configFile.delete();
    }

    public String getString(String path) {
        return this.cfg.getString(path);
    }

    public String getString(String path, String def) {
        return this.cfg.getString(path, def);
    }

    public List<String> getStringList(String path) {
        return this.cfg.getStringList(path);
    }

    public Configuration getSection(String path) {
        return this.cfg.getSection(path);
    }
}

