/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.BungeeResourcepacks.bungee.listeners;

import de.themoep.BungeeResourcepacks.bungee.BungeeResourcepacks;
import de.themoep.BungeeResourcepacks.core.ResourcePack;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class ServerSwitchListener
implements Listener {
    BungeeResourcepacks plugin;

    public ServerSwitchListener(BungeeResourcepacks plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onServerSwitch(ServerSwitchEvent event) {
        if (this.plugin.isEnabled()) {
            final UUID playerid = event.getPlayer().getUniqueId();
            this.plugin.unsetBackend(playerid);
            this.plugin.getProxy().getScheduler().schedule((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ProxiedPlayer player;
                    BungeeResourcepacks plugin = BungeeResourcepacks.getInstance();
                    if (!plugin.hasBackend(playerid) && (player = plugin.getProxy().getPlayer(playerid)) != null) {
                        ResourcePack prev = plugin.getPackManager().getUserPack(playerid);
                        Server server = player.getServer();
                        ResourcePack pack = null;
                        if (plugin.getPackManager().isGlobalSecondary(prev)) {
                            return;
                        }
                        if (server != null) {
                            if (plugin.getPackManager().isServerSecondary(server.getInfo().getName(), prev)) {
                                return;
                            }
                            pack = plugin.getPackManager().getServerPack(server.getInfo().getName());
                        }
                        if (pack == null) {
                            pack = plugin.getPackManager().getGlobalPack();
                        }
                        if (pack == null && prev != null) {
                            List<String> globalsecondary;
                            List<String> serversecondary;
                            if (server != null && (serversecondary = plugin.getPackManager().getServerSecondary(server.getInfo().getName())).size() > 0) {
                                pack = plugin.getPackManager().getByName(serversecondary.get(0));
                            }
                            if (pack == null && (globalsecondary = plugin.getPackManager().getGlobalSecondary()).size() > 0) {
                                pack = plugin.getPackManager().getByName(globalsecondary.get(0));
                            }
                            if (pack == null) {
                                pack = plugin.getPackManager().getEmptyPack();
                            }
                        }
                        if (pack != null && !pack.equals(prev)) {
                            plugin.setPack(player, pack);
                        }
                    }
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }
}

