/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.EditArmorStands;

import de.themoep.EditArmorStands.EditArmorStands;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ArmorStandGui
implements Listener {
    private final EditArmorStands plugin;
    private final ArmorStand armorStand;
    private final Player player;
    private static final Set<Material> HELMETS = new HashSet<Material>(Arrays.asList(Material.LEATHER_HELMET, Material.IRON_HELMET, Material.GOLD_HELMET, Material.DIAMOND_HELMET, Material.CHAINMAIL_HELMET, Material.SKULL_ITEM, Material.PUMPKIN));
    private static final Set<Material> CHESTPLATES = new HashSet<Material>(Arrays.asList(Material.LEATHER_CHESTPLATE, Material.IRON_CHESTPLATE, Material.GOLD_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE));
    private static final Set<Material> PANTS = new HashSet<Material>(Arrays.asList(Material.LEATHER_LEGGINGS, Material.IRON_LEGGINGS, Material.GOLD_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.CHAINMAIL_LEGGINGS));
    private static final Set<Material> BOOTS = new HashSet<Material>(Arrays.asList(Material.LEATHER_BOOTS, Material.IRON_BOOTS, Material.GOLD_BOOTS, Material.DIAMOND_BOOTS, Material.CHAINMAIL_BOOTS));
    private static final List<Integer> SLOTS_ARMORS = Arrays.asList(4, 13, 22, 31);
    private static final List<Integer> SLOTS_PLAYER = Arrays.asList(7, 16, 25, 34);
    private final ItemStack filler;
    private boolean open = false;
    private Inventory inventory = null;
    private InventoryView gui;
    private long lastClick = 0L;

    public ArmorStandGui(EditArmorStands plugin, ArmorStand armorStand, Player player) {
        this.plugin = plugin;
        this.armorStand = armorStand;
        this.player = player;
        if (plugin.getServerVersion() > 11100) {
            CHESTPLATES.add(Material.ELYTRA);
        }
        this.filler = new ItemStack(Material.STAINED_GLASS_PANE, 1, 15);
        ItemMeta fim = this.filler.getItemMeta();
        fim.setDisplayName(ChatColor.BLACK + "X");
        this.filler.setItemMeta(fim);
        this.build();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void build() {
        if (this.inventory == null) {
            this.inventory = this.plugin.getServer().createInventory(null, 36, "Armor Stand items:");
        }
        ItemStack[] items = new ItemStack[36];
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            items[i] = this.getSlotItem(i);
        }
        this.inventory.setContents(items);
    }

    public void show() {
        this.open = true;
        this.gui = this.player.openInventory(this.inventory);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (this.open && event.getWhoClicked().getUniqueId().equals(this.player.getUniqueId()) && event.getView() == this.gui) {
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                if (!event.getRawSlots().contains(i)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        block27: {
            if (this.open && event.getWhoClicked().getUniqueId().equals(this.player.getUniqueId()) && event.getView() == this.gui) {
                long curTime = System.currentTimeMillis();
                if (this.lastClick + 50L > curTime) {
                    event.setCancelled(true);
                    this.plugin.getLogger().log(Level.WARNING, event.getWhoClicked().getName() + " tried to click too fast (" + (curTime - this.lastClick) + "ms)");
                    event.getWhoClicked().sendMessage(ChatColor.RED + "Please wait a tiny bit longer between your clicks!");
                    return;
                }
                this.lastClick = System.currentTimeMillis();
                if (event.getRawSlot() > -1 && event.getRawSlot() < this.inventory.getSize()) {
                    ItemStack realItem;
                    if (event.getSlot() == 8) {
                        event.setCancelled(true);
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> ((Player)this.player).closeInventory());
                        return;
                    }
                    ItemStack cur = event.getCurrentItem();
                    if (!this.areEqual(cur, realItem = this.getSlotItem(event.getSlot()))) {
                        event.setCancelled(true);
                        this.plugin.getLogger().log(Level.WARNING, "The item " + event.getWhoClicked().getName() + " tried to pickup was not the same as the one in the inventory (Armor Stand or player)! Duping attempt?");
                        event.setCurrentItem(realItem);
                        event.getWhoClicked().sendMessage(ChatColor.RED + "This inventory's items were modified! Please try again!");
                        return;
                    }
                    if (this.isBound(event.getSlot())) {
                        event.setCancelled(true);
                        event.getWhoClicked().sendMessage(ChatColor.RED + "This item is bound to you!");
                        return;
                    }
                    ItemStack hand = event.getCursor();
                    try {
                        ItemStack result = this.getResultItem(event.getSlot(), event.getAction(), cur, hand);
                        if (!this.setSlot(event.getSlot(), result)) {
                            event.setCancelled(true);
                        } else if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && (SLOTS_PLAYER.contains(event.getSlot()) || SLOTS_ARMORS.contains(event.getSlot()))) {
                            this.build();
                            event.setCancelled(true);
                        }
                    }
                    catch (ActionNotSupported e) {
                        if (event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) {
                            event.setCancelled(true);
                            ItemStack hbItem = event.getWhoClicked().getInventory().getItem(event.getHotbarButton());
                            if (this.setSlot(event.getSlot(), hbItem)) {
                                this.build();
                                event.getWhoClicked().getInventory().setItem(event.getHotbarButton(), cur);
                            } else {
                                int emptySlot = event.getWhoClicked().getInventory().firstEmpty();
                                if (emptySlot > 0 && this.setSlot(event.getSlot(), null)) {
                                    this.build();
                                    event.getWhoClicked().getInventory().setItem(event.getHotbarButton(), cur);
                                    event.getWhoClicked().getInventory().setItem(emptySlot, hbItem);
                                }
                            }
                            break block27;
                        }
                        if (event.getAction() == InventoryAction.HOTBAR_SWAP) {
                            event.setCancelled(true);
                            ItemStack hbItem = event.getWhoClicked().getInventory().getItem(event.getHotbarButton());
                            if (this.setSlot(event.getSlot(), hbItem)) {
                                this.build();
                                event.getWhoClicked().getInventory().setItem(event.getHotbarButton(), cur);
                            }
                            break block27;
                        }
                        event.setCancelled(true);
                    }
                    catch (ItemNotSuitable e) {
                        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && (SLOTS_PLAYER.contains(event.getSlot()) || SLOTS_ARMORS.contains(event.getSlot()))) {
                            this.setSlot(event.getSlot(), null);
                            event.setCancelled(false);
                            break block27;
                        }
                        event.setCancelled(true);
                    }
                } else if (event.getRawSlot() >= this.inventory.getSize()) {
                    if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                        event.setCancelled(true);
                        ArrayList<Integer> slots = new ArrayList<Integer>(SLOTS_ARMORS);
                        slots.addAll(SLOTS_PLAYER);
                        slots.add(12);
                        if (this.plugin.getServerVersion() >= 10900) {
                            slots.add(14);
                        }
                        Iterator iterator = slots.iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            ItemStack target = event.getWhoClicked().getOpenInventory().getTopInventory().getItem(i);
                            if (target != null && target.getType() != Material.AIR || !this.isValidItem(i, event.getCurrentItem())) continue;
                            if (this.setSlot(i, event.getCurrentItem())) {
                                event.getWhoClicked().getInventory().setItem(event.getSlot(), null);
                                this.build();
                            }
                            break;
                        }
                    } else if (event.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
                        event.setCancelled(true);
                    }
                }
            }
        }
    }

    private boolean isBound(int slot) {
        if (this.plugin.getServerVersion() >= 11100 && this.player.getGameMode() != GameMode.CREATIVE && SLOTS_PLAYER.contains(slot)) {
            ItemStack item = this.getSlotItem(slot);
            return item != null && item.containsEnchantment(Enchantment.BINDING_CURSE);
        }
        return false;
    }

    private boolean areEqual(ItemStack item1, ItemStack item2) {
        if (!(item1 != null && item1.getType() != Material.AIR || item2 != null && item2.getType() != Material.AIR)) {
            return true;
        }
        if (item1 != null && item2 != null) {
            return item1.equals((Object)item2);
        }
        return false;
    }

    private boolean setSlot(int slot, ItemStack item) {
        if (this.isValidItem(slot, item)) {
            switch (slot) {
                case 4: {
                    this.armorStand.setHelmet(item);
                    break;
                }
                case 12: {
                    this.armorStand.setItemInHand(item);
                    break;
                }
                case 13: {
                    this.armorStand.setChestplate(item);
                    break;
                }
                case 14: {
                    if (this.plugin.getServerVersion() < 10900) {
                        return false;
                    }
                    this.armorStand.getEquipment().setItemInOffHand(item);
                    break;
                }
                case 22: {
                    this.armorStand.setLeggings(item);
                    break;
                }
                case 31: {
                    this.armorStand.setBoots(item);
                    break;
                }
                case 7: {
                    this.player.getInventory().setHelmet(item);
                    break;
                }
                case 16: {
                    this.player.getInventory().setChestplate(item);
                    break;
                }
                case 25: {
                    this.player.getInventory().setLeggings(item);
                    break;
                }
                case 34: {
                    this.player.getInventory().setBoots(item);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private ItemStack getSlotItem(int slot) {
        switch (slot) {
            case 4: {
                return this.armorStand.getHelmet();
            }
            case 12: {
                return this.armorStand.getItemInHand();
            }
            case 13: {
                return this.armorStand.getChestplate();
            }
            case 14: {
                if (this.plugin.getServerVersion() < 10900) {
                    ItemStack leftArm = new ItemStack(Material.STAINED_GLASS_PANE, 1, 14);
                    ItemMeta laim = leftArm.getItemMeta();
                    laim.setDisplayName(ChatColor.RED + "The offhand item cannot be set in 1.8!");
                    leftArm.setItemMeta(laim);
                    return leftArm;
                }
                return this.armorStand.getEquipment().getItemInOffHand();
            }
            case 22: {
                return this.armorStand.getLeggings();
            }
            case 31: {
                return this.armorStand.getBoots();
            }
            case 7: {
                return this.player.getInventory().getHelmet();
            }
            case 16: {
                return this.player.getInventory().getChestplate();
            }
            case 25: {
                return this.player.getInventory().getLeggings();
            }
            case 34: {
                return this.player.getInventory().getBoots();
            }
            case 8: {
                ItemStack close = new ItemStack(Material.BARRIER);
                ItemMeta cim = close.getItemMeta();
                cim.setDisplayName(ChatColor.RED + "Close");
                close.setItemMeta(cim);
                return close;
            }
        }
        return this.filler;
    }

    private ItemStack getResultItem(int slot, InventoryAction action, ItemStack current, ItemStack hand) throws ActionNotSupported, ItemNotSuitable {
        ItemStack curClone = current == null ? null : current.clone();
        ItemStack handClone = hand == null ? null : hand.clone();
        switch (action) {
            case DROP_ALL_SLOT: 
            case PICKUP_ALL: {
                return null;
            }
            case SWAP_WITH_CURSOR: {
                return handClone;
            }
            case CLONE_STACK: {
                return curClone;
            }
            case PLACE_ALL: {
                if (curClone != null && handClone != null) {
                    handClone.setAmount(curClone.getAmount() + handClone.getAmount());
                }
                return handClone;
            }
            case DROP_ONE_SLOT: 
            case PICKUP_ONE: {
                if (curClone != null) {
                    curClone.setAmount(curClone.getAmount() - 1);
                }
                return curClone;
            }
            case PLACE_ONE: {
                if (handClone != null) {
                    handClone.setAmount(1);
                }
                return handClone;
            }
            case PLACE_SOME: {
                if (curClone != null) {
                    curClone.setAmount(curClone.getMaxStackSize());
                }
                return curClone;
            }
            case PICKUP_SOME: {
                if (curClone != null && handClone != null) {
                    curClone.setAmount(curClone.getAmount() - (handClone.getMaxStackSize() - handClone.getAmount()));
                } else if (curClone != null) {
                    int amount = curClone.getAmount() - curClone.getMaxStackSize();
                    curClone.setAmount(amount > 0 ? amount : 0);
                }
                return curClone;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                if (SLOTS_PLAYER.contains(slot) || SLOTS_ARMORS.contains(slot)) {
                    return this.swap(slot);
                }
                return null;
            }
        }
        throw new ActionNotSupported();
    }

    private ItemStack swap(int slot) throws ItemNotSuitable {
        int swap = this.getSwap(slot);
        ItemStack slotItem = this.getSlotItem(slot);
        ItemStack item = this.getSlotItem(swap);
        if (!this.isBound(slot) && !this.isBound(swap) && this.isValidItem(slot, item) && this.setSlot(swap, slotItem)) {
            return item;
        }
        throw new ItemNotSuitable();
    }

    private int getSwap(int slot) {
        int swap = -1;
        if (SLOTS_ARMORS.contains(slot)) {
            swap = SLOTS_PLAYER.get(SLOTS_ARMORS.indexOf(slot));
        } else if (SLOTS_PLAYER.contains(slot)) {
            swap = SLOTS_ARMORS.get(SLOTS_PLAYER.indexOf(slot));
        }
        return swap;
    }

    private boolean isValidItem(int slot, ItemStack itemStack) {
        boolean empty = itemStack == null || itemStack.getType() == Material.AIR;
        switch (slot) {
            case 4: {
                return empty || HELMETS.contains(itemStack.getType()) || itemStack.getType().isBlock();
            }
            case 7: {
                return empty || HELMETS.contains(itemStack.getType());
            }
            case 12: {
                return true;
            }
            case 14: {
                return this.plugin.getServerVersion() >= 10900;
            }
            case 13: 
            case 16: {
                return empty || CHESTPLATES.contains(itemStack.getType());
            }
            case 22: 
            case 25: {
                return empty || PANTS.contains(itemStack.getType());
            }
            case 31: 
            case 34: {
                return empty || BOOTS.contains(itemStack.getType());
            }
        }
        return false;
    }

    @EventHandler
    public void onArmorStandInteract(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked().getUniqueId().equals(this.armorStand.getUniqueId())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(ChatColor.RED + "Can't manipulate this Armor Stand! " + ChatColor.GOLD + this.player.getName() + ChatColor.RED + " is currently editing it!");
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer().getUniqueId().equals(this.player.getUniqueId()) && event.getView() == this.gui) {
            this.destroy();
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (event.getPlayer().getUniqueId().equals(this.player.getUniqueId())) {
            this.destroy();
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (event.getEntity().getUniqueId().equals(this.player.getUniqueId())) {
            this.destroy();
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getPlayer().getUniqueId().equals(this.player.getUniqueId())) {
            this.destroy();
            this.player.closeInventory();
        }
    }

    @EventHandler
    public void onArmorStandDestroy(EntityDeathEvent event) {
        if (event.getEntity().getUniqueId().equals(this.armorStand.getUniqueId()) && this.open) {
            this.destroy();
            this.player.closeInventory();
        }
    }

    private void destroy() {
        HandlerList.unregisterAll((Listener)this);
        this.open = false;
    }

    private class ItemNotSuitable
    extends Throwable {
        private ItemNotSuitable() {
        }
    }

    private class ActionNotSupported
    extends Throwable {
        private ActionNotSupported() {
        }
    }
}

