/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.EditArmorStands;

import de.themoep.EditArmorStands.ArmorStandGui;
import de.themoep.EditArmorStands.EditArmorStands;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ArmorStandListener
implements Listener {
    private EditArmorStands plugin;

    public ArmorStandListener(EditArmorStands plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onArmorStandClick(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked() instanceof ArmorStand) {
            PlayerInteractEntityEvent pie = new PlayerInteractEntityEvent(event.getPlayer(), event.getRightClicked());
            this.plugin.getServer().getPluginManager().callEvent((Event)pie);
            if (pie.isCancelled()) {
                return;
            }
            ArmorStand armorStand = (ArmorStand)event.getRightClicked();
            if (this.plugin.hasWaitingAction(event.getPlayer())) {
                event.setCancelled(true);
                this.plugin.calculateAction(event.getPlayer(), armorStand, this.plugin.getWaitingAction(event.getPlayer()));
                this.plugin.removeWaitingAction(event.getPlayer());
                return;
            }
            if (this.plugin.getPersistentAction(event.getPlayer()) != null) {
                event.setCancelled(true);
                this.plugin.calculateAction(event.getPlayer(), armorStand, this.plugin.getPersistentAction(event.getPlayer()));
                return;
            }
            if (event.getPlayer().getItemInHand().getType() == Material.NAME_TAG) {
                ItemStack hi = event.getPlayer().getItemInHand();
                if (hi.hasItemMeta() && hi.getItemMeta().hasDisplayName()) {
                    if (event.getPlayer().hasPermission("editarmorstands.nametag.name")) {
                        event.setCancelled(true);
                        String name = hi.getItemMeta().getDisplayName();
                        name = event.getPlayer().hasPermission("editarmorstands.nametag.name.colored") ? ChatColor.translateAlternateColorCodes((char)'&', (String)name) : ChatColor.ITALIC + name;
                        armorStand.setCustomName(name + ChatColor.RESET);
                        armorStand.setCustomNameVisible(true);
                        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                            if (hi.getAmount() > 1) {
                                hi.setAmount(hi.getAmount() - 1);
                            } else {
                                event.getPlayer().setItemInHand(new ItemStack(Material.AIR));
                            }
                            event.getPlayer().updateInventory();
                        }
                        return;
                    }
                } else if (event.getPlayer().hasPermission("editarmorstands.nametag.name.clear")) {
                    event.setCancelled(true);
                    armorStand.setCustomName("");
                    armorStand.setCustomNameVisible(false);
                    return;
                }
            } else if (!event.getPlayer().isSneaking() && event.getPlayer().hasPermission("editarmorstands.openinventory")) {
                event.setCancelled(true);
                ArmorStandGui gui = new ArmorStandGui(this.plugin, armorStand, event.getPlayer());
                gui.show();
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onArmorStandDestroy(EntityDeathEvent event) {
        if (event.getEntity().getType() == EntityType.ARMOR_STAND && this.plugin.isSelected((Entity)event.getEntity())) {
            this.plugin.removeSelected((Entity)event.getEntity());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onArmorStandPlace(PlayerInteractEvent event) {
        boolean isNamedArmorStand;
        boolean isArmorStandPlacement = event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getItem() != null && event.getItem().getType() == Material.ARMOR_STAND;
        boolean bl = isNamedArmorStand = isArmorStandPlacement && event.getItem().hasItemMeta() && event.getItem().getItemMeta().hasDisplayName();
        if (isNamedArmorStand && event.getPlayer().hasPermission("editarmorstands.place.name")) {
            String name = event.getItem().getItemMeta().getDisplayName();
            name = event.getPlayer().hasPermission("editarmorstands.place.name.colored") ? ChatColor.translateAlternateColorCodes((char)'&', (String)name) : ChatColor.ITALIC + name;
            final Location loc = event.getClickedBlock().getRelative(event.getBlockFace()).getLocation();
            final String finalName = name + ChatColor.RESET;
            Listener spawnListener = new Listener(){

                @EventHandler
                public void onArmorStandSpawn(CreatureSpawnEvent event) {
                    if (event.getEntity().getType() == EntityType.ARMOR_STAND && event.getEntity().getLocation().getBlock().getLocation().equals((Object)loc)) {
                        event.getEntity().setCustomName(finalName);
                        event.getEntity().setCustomNameVisible(true);
                    }
                }
            };
            this.plugin.getServer().getPluginManager().registerEvents(spawnListener, (Plugin)this.plugin);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> HandlerList.unregisterAll((Listener)spawnListener), 20L);
        }
    }
}

