/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.EditArmorStands;

import de.themoep.EditArmorStands.Axis;
import de.themoep.EditArmorStands.BodyPart;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ArmorStandPoser {
    private ArmorStand as;

    public ArmorStandPoser(ArmorStand as) {
        this.as = as;
    }

    public int setSingleAngle(BodyPart part, Axis axis, int angle, boolean relative) {
        try {
            if (part == BodyPart.HEAD) {
                EulerAngle ea = this.as.getHeadPose();
                this.as.setHeadPose(this.getEulerAngleFromInput(axis, ea, angle, relative));
                if (relative) {
                    double rad = 0.0;
                    switch (axis) {
                        case YAW: {
                            rad = ea.getX();
                            break;
                        }
                        case PITCH: {
                            rad = ea.getY();
                            break;
                        }
                        case ROLL: {
                            rad = ea.getZ();
                        }
                    }
                    return (int)Math.toDegrees(rad);
                }
            } else {
                if (part == BodyPart.BODY) {
                    this.as.setBodyPose(this.getEulerAngleFromInput(axis, this.as.getBodyPose(), angle, relative));
                    return relative ? (int)Math.toDegrees(this.as.getBodyPose().getX()) : angle;
                }
                if (part == BodyPart.LEFTARM) {
                    this.as.setLeftArmPose(this.getEulerAngleFromInput(axis, this.as.getLeftArmPose(), angle, relative));
                    return relative ? (int)Math.toDegrees(this.as.getLeftArmPose().getX()) : angle;
                }
                if (part == BodyPart.LEFTLEG) {
                    this.as.setLeftLegPose(this.getEulerAngleFromInput(axis, this.as.getLeftLegPose(), angle, relative));
                    return relative ? (int)Math.toDegrees(this.as.getLeftLegPose().getX()) : angle;
                }
                if (part == BodyPart.RIGHTARM) {
                    this.as.setRightArmPose(this.getEulerAngleFromInput(axis, this.as.getRightArmPose(), angle, relative));
                    return relative ? (int)Math.toDegrees(this.as.getRightArmPose().getX()) : angle;
                }
                if (part == BodyPart.RIGHTLEG) {
                    this.as.setRightLegPose(this.getEulerAngleFromInput(axis, this.as.getRightLegPose(), angle, relative));
                    return relative ? (int)Math.toDegrees(this.as.getRightLegPose().getX()) : angle;
                }
            }
            return angle;
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Null pointer at asp.setSingleAngle(" + (Object)((Object)part) + ", " + (Object)((Object)axis) + ", " + angle + ", " + relative + ")!");
        }
    }

    private EulerAngle getEulerAngleFromInput(Axis axis, EulerAngle ea, int angle, boolean relative) {
        switch (axis) {
            case PITCH: {
                double x = Math.toRadians(angle);
                if (relative) {
                    x += ea.getX();
                }
                return ea.setX(x);
            }
            case YAW: {
                double y = Math.toRadians(angle);
                if (relative) {
                    y += ea.getY();
                }
                return ea.setY(y);
            }
            case ROLL: {
                double z = Math.toRadians(angle);
                if (relative) {
                    z += ea.getZ();
                }
                return ea.setZ(z);
            }
        }
        return null;
    }

    public int[] setEulerAngle(BodyPart part, int[] angles, boolean[] relatives) throws IllegalArgumentException {
        if (angles.length >= 3 && relatives.length >= 3) {
            boolean relative = relatives[0] && relatives[1] && relatives[2];
            switch (part) {
                case HEAD: {
                    int[] nArray;
                    EulerAngle ea = this.as.getHeadPose();
                    ea = this.getNewEulerAngle(ea, angles, relatives);
                    this.as.setHeadPose(ea);
                    if (relative) {
                        int[] nArray2 = new int[3];
                        nArray2[0] = (int)Math.toDegrees(ea.getX());
                        nArray2[1] = (int)Math.toDegrees(ea.getY());
                        nArray = nArray2;
                        nArray2[2] = (int)Math.toDegrees(ea.getZ());
                    } else {
                        nArray = angles;
                    }
                    return nArray;
                }
                case BODY: {
                    int[] nArray;
                    EulerAngle ea = this.as.getBodyPose();
                    ea = this.getNewEulerAngle(ea, angles, relatives);
                    this.as.setBodyPose(ea);
                    if (relative) {
                        int[] nArray3 = new int[3];
                        nArray3[0] = (int)Math.toDegrees(ea.getX());
                        nArray3[1] = (int)Math.toDegrees(ea.getY());
                        nArray = nArray3;
                        nArray3[2] = (int)Math.toDegrees(ea.getZ());
                    } else {
                        nArray = angles;
                    }
                    return nArray;
                }
                case LEFTARM: {
                    int[] nArray;
                    EulerAngle ea = this.as.getLeftArmPose();
                    ea = this.getNewEulerAngle(ea, angles, relatives);
                    this.as.setLeftArmPose(ea);
                    if (relative) {
                        int[] nArray4 = new int[3];
                        nArray4[0] = (int)Math.toDegrees(ea.getX());
                        nArray4[1] = (int)Math.toDegrees(ea.getY());
                        nArray = nArray4;
                        nArray4[2] = (int)Math.toDegrees(ea.getZ());
                    } else {
                        nArray = angles;
                    }
                    return nArray;
                }
                case LEFTLEG: {
                    int[] nArray;
                    EulerAngle ea = this.as.getLeftLegPose();
                    ea = this.getNewEulerAngle(ea, angles, relatives);
                    this.as.setLeftLegPose(ea);
                    if (relative) {
                        int[] nArray5 = new int[3];
                        nArray5[0] = (int)Math.toDegrees(ea.getX());
                        nArray5[1] = (int)Math.toDegrees(ea.getY());
                        nArray = nArray5;
                        nArray5[2] = (int)Math.toDegrees(ea.getZ());
                    } else {
                        nArray = angles;
                    }
                    return nArray;
                }
                case RIGHTARM: {
                    int[] nArray;
                    EulerAngle ea = this.as.getRightArmPose();
                    ea = this.getNewEulerAngle(ea, angles, relatives);
                    this.as.setRightArmPose(ea);
                    if (relative) {
                        int[] nArray6 = new int[3];
                        nArray6[0] = (int)Math.toDegrees(ea.getX());
                        nArray6[1] = (int)Math.toDegrees(ea.getY());
                        nArray = nArray6;
                        nArray6[2] = (int)Math.toDegrees(ea.getZ());
                    } else {
                        nArray = angles;
                    }
                    return nArray;
                }
                case RIGHTLEG: {
                    int[] nArray;
                    EulerAngle ea = this.as.getRightLegPose();
                    ea = this.getNewEulerAngle(ea, angles, relatives);
                    this.as.setRightLegPose(ea);
                    if (relative) {
                        int[] nArray7 = new int[3];
                        nArray7[0] = (int)Math.toDegrees(ea.getX());
                        nArray7[1] = (int)Math.toDegrees(ea.getY());
                        nArray = nArray7;
                        nArray7[2] = (int)Math.toDegrees(ea.getZ());
                    } else {
                        nArray = angles;
                    }
                    return nArray;
                }
            }
            throw new IllegalArgumentException("We encountered an error. Please report that immediately to a dev! asp.setEulerAngle(" + (Object)((Object)part) + ", " + angles[0] + ", " + angles[1] + ", " + angles[3] + ", " + relatives + ")");
        }
        throw new IllegalArgumentException("Please input 3 angles!");
    }

    private EulerAngle getNewEulerAngle(EulerAngle ea, int[] angles, boolean[] relatives) {
        if (angles.length >= 3 && relatives.length >= 3) {
            ea = new EulerAngle(relatives[0] ? Math.toRadians(angles[0]) + ea.getX() : Math.toRadians(angles[0]), relatives[1] ? Math.toRadians(angles[1]) + ea.getY() : Math.toRadians(angles[1]), relatives[2] ? Math.toRadians(angles[2]) + ea.getZ() : Math.toRadians(angles[2]));
            return ea;
        }
        throw new IllegalArgumentException("Please input 3 angles!");
    }

    public boolean translatePlayerLook(BodyPart part, Location location) {
        Vector v = location.getDirection();
        EulerAngle ea = new EulerAngle(v.getX(), v.getY(), v.getZ());
        switch (part) {
            case HEAD: {
                this.as.setHeadPose(ea);
                return true;
            }
            case BODY: {
                this.as.setBodyPose(ea);
                return true;
            }
            case LEFTARM: {
                this.as.setLeftArmPose(ea);
                return true;
            }
            case LEFTLEG: {
                this.as.setLeftLegPose(ea);
                return true;
            }
            case RIGHTARM: {
                this.as.setRightArmPose(ea);
                return true;
            }
            case RIGHTLEG: {
                this.as.setRightLegPose(ea);
                return true;
            }
        }
        return false;
    }
}

