/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.EditArmorStands;

import java.util.Arrays;

public enum Axis {
    YAW(new String[]{"y, heading, h"}),
    PITCH(new String[]{"p, elevation, e"}),
    ROLL(new String[]{"r, bank, b"});

    private String[] alias;
    private static String valuestring;

    private Axis(String[] alias) {
        this.alias = alias;
    }

    public static Axis fromString(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        try {
            return Axis.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            for (Axis x : Axis.values()) {
                for (String a : x.alias) {
                    if (!a.equalsIgnoreCase(name)) continue;
                    return x;
                }
            }
            throw new IllegalArgumentException(name + " is not an axis! Available axis are " + valuestring.toLowerCase().substring(1, valuestring.length() - 1));
        }
    }

    static {
        valuestring = Arrays.toString((Object[])Axis.values());
    }
}

