/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.EditArmorStands;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.themoep.EditArmorStands.ArmorStandGui;
import de.themoep.EditArmorStands.ArmorStandListener;
import de.themoep.EditArmorStands.ArmorStandPoser;
import de.themoep.EditArmorStands.Axis;
import de.themoep.EditArmorStands.BodyPart;
import de.themoep.EditArmorStands.EditArmorStandsCommand;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EditArmorStands
extends JavaPlugin {
    private Map<UUID, UUID> selectedArmorStands = new HashMap<UUID, UUID>();
    private Cache<UUID, String[]> waitingCommands = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private Map<UUID, String[]> persistent = new HashMap<UUID, String[]>();
    private static DecimalFormat df = new DecimalFormat("#.##");
    private int serverVersion = 0;

    public void onEnable() {
        Matcher versionMatcher = Pattern.compile(".*\\(MC: (.*)\\)").matcher(this.getServer().getVersion());
        if (versionMatcher.find()) {
            String[] version = versionMatcher.group(1).split("[.]");
            for (int i = 0; i < version.length && i < 3; ++i) {
                try {
                    int n = Integer.parseInt(version[i]);
                    this.serverVersion = (int)((double)this.serverVersion + (double)n * Math.pow(100.0, 2 - i));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.getLogger().warning("Could not parse " + version[i] + " as an integer?");
                }
            }
        }
        if (this.serverVersion != 0) {
            this.getLogger().info("Detect server " + this.serverVersion);
            if (this.serverVersion < 10800) {
                this.getLogger().warning("Armor Stands weren't in Minecraft before 1.8? What are you trying to do with this plugin?");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        } else {
            this.getLogger().warning("Could not detect server version!");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new ArmorStandListener(this), (Plugin)this);
        this.getCommand("editarmorstand").setExecutor((CommandExecutor)new EditArmorStandsCommand(this));
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    boolean calculateAction(Player player, ArmorStand as, String[] args) {
        block77: {
            if (args.length == 0) {
                this.addSelection(player, as);
                player.sendMessage(ChatColor.GREEN + "Selected Armor Stand at " + ChatColor.YELLOW + as.getLocation().getBlockX() + "/" + as.getLocation().getBlockY() + "/" + as.getLocation().getBlockZ() + ChatColor.GREEN + "!");
                player.getPlayer().sendMessage(ChatColor.GREEN + "You can now use " + ChatColor.YELLOW + "/eas <option> <value> " + ChatColor.GREEN + "to edit the properties of this Armor Stand! To exit the editing mode run " + ChatColor.YELLOW + "/eas exit" + ChatColor.GREEN + "!");
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("name")) {
                if (player.hasPermission("editarmorstands.command.name")) {
                    if (args.length > 1) {
                        String name = "";
                        for (int i = 1; i < args.length; ++i) {
                            name = name + args[i] + " ";
                        }
                        if (player.hasPermission("editarmorstands.command.name.colored")) {
                            name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
                        }
                        as.setCustomName(name.trim() + ChatColor.RESET);
                        player.sendMessage(ChatColor.GREEN + "Set the Armor Stand's name to " + ChatColor.RESET + as.getCustomName() + ChatColor.GREEN + "!");
                    } else {
                        as.setCustomName(null);
                        player.sendMessage(ChatColor.GREEN + "Removed the Armor Stand's name!");
                    }
                    return true;
                }
                player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.name");
            } else if (args.length == 1) {
                if (args[0].equalsIgnoreCase("items") || args[0].equalsIgnoreCase("inv") || args[0].equalsIgnoreCase("i")) {
                    if (player.hasPermission("editarmorstands.command.items")) {
                        ArmorStandGui gui = new ArmorStandGui(this, as, player);
                        gui.show();
                        return true;
                    }
                    player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.items");
                } else if (args[0].equalsIgnoreCase("namevisible")) {
                    if (player.hasPermission("editarmorstands.command.namevisible")) {
                        as.setCustomNameVisible(!as.isCustomNameVisible());
                        player.sendMessage(ChatColor.GREEN + "The Armor Stand's name is now " + ChatColor.YELLOW + (as.isCustomNameVisible() ? "" : "in") + "visible" + ChatColor.GREEN + "!");
                        return true;
                    }
                    player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.namevisible");
                } else if (args[0].equalsIgnoreCase("arms")) {
                    if (player.hasPermission("editarmorstands.command.arms")) {
                        as.setArms(!as.hasArms());
                        player.sendMessage(ChatColor.GREEN + "Armor Stand has now " + ChatColor.YELLOW + (as.hasArms() ? "" : "no ") + "arms" + ChatColor.GREEN + "!");
                        return true;
                    }
                    player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.arms");
                } else if (args[0].equalsIgnoreCase("base")) {
                    if (player.hasPermission("editarmorstands.command.base")) {
                        as.setBasePlate(!as.hasBasePlate());
                        player.sendMessage(ChatColor.GREEN + "Armor Stand has now " + ChatColor.YELLOW + (as.hasBasePlate() ? "a" : "no") + " baseplate" + ChatColor.GREEN + "!");
                        return true;
                    }
                    player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.base");
                } else if (args[0].equalsIgnoreCase("gravity")) {
                    if (player.hasPermission("editarmorstands.command.gravity")) {
                        as.setGravity(!as.hasGravity());
                        player.sendMessage(ChatColor.GREEN + "Armor Stand has now " + ChatColor.YELLOW + (as.hasGravity() ? "" : "no ") + "gravity" + ChatColor.GREEN + "!");
                        return true;
                    }
                    player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.gravity");
                } else if (args[0].equalsIgnoreCase("size")) {
                    if (player.hasPermission("editarmorstands.command.size")) {
                        as.setSmall(!as.isSmall());
                        player.sendMessage(ChatColor.GREEN + "Armor Stand is now " + ChatColor.YELLOW + (as.isSmall() ? "small" : "big") + ChatColor.GREEN + "!");
                        return true;
                    }
                    player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.size");
                } else if (args[0].equalsIgnoreCase("visible")) {
                    if (player.hasPermission("editarmorstands.command.visible")) {
                        as.setVisible(!as.isVisible());
                        player.sendMessage(ChatColor.GREEN + "Armor Stand is now " + ChatColor.YELLOW + (as.isVisible() ? "" : "in") + "visible" + ChatColor.GREEN + "!");
                        return true;
                    }
                    player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.visible");
                }
            } else if (args.length == 2) {
                if (player.hasPermission("editarmorstands.command.pose")) {
                    try {
                        int angle;
                        boolean relative = false;
                        if (args[1].startsWith("~")) {
                            relative = true;
                            angle = args[1].length() == 1 ? 0 : Integer.parseInt(args[1].substring(1));
                        } else {
                            angle = Integer.parseInt(args[1]);
                        }
                        if (args[0].equalsIgnoreCase("p") || args[0].equalsIgnoreCase("pitch")) {
                            Location l = as.getLocation();
                            if (relative) {
                                angle = (int)((float)angle + l.getPitch());
                            }
                            l.setPitch((float)angle);
                            as.teleport(l);
                            break block77;
                        }
                        if (args[0].equalsIgnoreCase("y") || args[0].equalsIgnoreCase("yaw") || args[0].equalsIgnoreCase("r") || args[0].equalsIgnoreCase("rotate") || args[0].equalsIgnoreCase("rotation")) {
                            Location l = as.getLocation();
                            if (relative) {
                                angle = (int)((float)angle + l.getYaw());
                            }
                            l.setYaw((float)angle);
                            as.teleport(l);
                            player.sendMessage(ChatColor.GREEN + "Set Armor Stand's rotation to " + ChatColor.YELLOW + angle + ChatColor.GREEN + "!");
                            return true;
                        }
                        player.sendMessage(ChatColor.RED + "Sorry but the option " + args[0] + " doesn't exist!");
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ChatColor.RED + "Your second argument " + args[1] + " is not a number!");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.pose");
                }
            } else if (args.length == 3) {
                if (player.hasPermission("editarmorstands.command.pose")) {
                    try {
                        int angle;
                        boolean relative = false;
                        if (args[2].startsWith("~")) {
                            relative = true;
                            angle = args[2].length() == 1 ? 0 : Integer.parseInt(args[2].substring(1));
                        } else {
                            angle = Integer.parseInt(args[2]);
                        }
                        try {
                            ArmorStandPoser asp = new ArmorStandPoser(as);
                            BodyPart bp = BodyPart.fromString(args[0]);
                            Axis a = Axis.fromString(args[1]);
                            int n = asp.setSingleAngle(bp, a, angle, relative);
                            player.sendMessage(ChatColor.GREEN + "Set " + bp.name().toLowerCase() + "'s " + a.name().toLowerCase() + " to " + ChatColor.YELLOW + n + ChatColor.GREEN + "!");
                            return true;
                        }
                        catch (IllegalArgumentException e) {
                            player.sendMessage(ChatColor.RED + e.getMessage());
                        }
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ChatColor.RED + "Your third argument " + args[1] + " is not a number!");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.pose");
                }
            } else if (args.length == 4) {
                if (args[0].equalsIgnoreCase("move") || args[0].equalsIgnoreCase("mv")) {
                    if (player.hasPermission("editarmorstands.command.move")) {
                        Location loc = as.getLocation();
                        int[] blockLoc = new int[]{loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()};
                        double[] locArr = new double[]{loc.getX(), loc.getY(), loc.getZ()};
                        double[] oldLocArr = new double[]{loc.getX(), loc.getY(), loc.getZ()};
                        for (int i = 0; i < 3; ++i) {
                            try {
                                if (args[i + 1].startsWith("~")) {
                                    if (args[i + 1].length() != 1) {
                                        int n = i;
                                        locArr[n] = locArr[n] + Double.parseDouble(args[i + 1].substring(1));
                                    }
                                } else {
                                    locArr[i] = Double.parseDouble(args[i + 1]);
                                }
                                if (Math.floor(locArr[i]) != (double)blockLoc[i] && !player.hasPermission("editarmorstands.command.move.nextblock") && !player.hasPermission("editarmorstands.command.move.unlimited")) {
                                    player.sendMessage(ChatColor.RED + "You can only manipulate the position of an Armor Stands on the " + ChatColor.GOLD + "same block" + ChatColor.RED + ", not move it onto another block! (" + args[i + 1] + " would move it onto another one!)");
                                    return false;
                                }
                                if (!(Math.abs(locArr[i] - oldLocArr[i]) > 1.0) || player.hasPermission("editarmorstands.command.move.unlimited")) continue;
                                player.sendMessage(ChatColor.RED + "You can't move Armor Stands more than " + ChatColor.GOLD + "one block" + ChatColor.RED + "! You inputted " + ChatColor.GOLD + args[i + 1] + ChatColor.RED + "!");
                                return false;
                            }
                            catch (NumberFormatException e) {
                                player.sendMessage(ChatColor.GOLD + args[i + 1].substring(1) + ChatColor.RED + " is not a valid double!");
                                return false;
                            }
                        }
                        loc.setX(locArr[0]);
                        loc.setY(locArr[1]);
                        loc.setZ(locArr[2]);
                        as.teleport(loc);
                        player.sendMessage(ChatColor.GREEN + "Moved the Armor Stand to " + ChatColor.YELLOW + df.format(loc.getX()) + " / " + ChatColor.YELLOW + df.format(loc.getY()) + " / " + ChatColor.YELLOW + df.format(loc.getZ()) + ChatColor.GREEN + "!");
                    } else {
                        player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.move");
                    }
                } else if (player.hasPermission("editarmorstands.command.pose")) {
                    ArmorStandPoser asp = new ArmorStandPoser(as);
                    try {
                        int z;
                        int y;
                        int x;
                        boolean rx = false;
                        boolean ry = false;
                        boolean rz = false;
                        if (args[1].startsWith("~")) {
                            rx = true;
                            x = args[1].length() == 1 ? 0 : Integer.parseInt(args[1].substring(1));
                        } else {
                            x = Integer.parseInt(args[1]);
                        }
                        if (args[2].startsWith("~")) {
                            ry = true;
                            y = args[2].length() == 1 ? 0 : Integer.parseInt(args[2].substring(1));
                        } else {
                            y = Integer.parseInt(args[2]);
                        }
                        if (args[3].startsWith("~")) {
                            rz = true;
                            z = args[3].length() == 1 ? 0 : Integer.parseInt(args[3].substring(1));
                        } else {
                            z = Integer.parseInt(args[3]);
                        }
                        try {
                            BodyPart bp = BodyPart.fromString(args[0]);
                            int[] r = asp.setEulerAngle(bp, new int[]{x, y, z}, new boolean[]{rx, ry, rz});
                            player.sendMessage(ChatColor.GREEN + "Set " + bp.name().toLowerCase() + " to " + ChatColor.YELLOW + r[0] + " " + r[1] + " " + r[2] + ChatColor.GREEN + "!");
                            return true;
                        }
                        catch (IllegalArgumentException e) {
                            player.sendMessage(ChatColor.RED + e.getMessage());
                        }
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ChatColor.RED + "One of " + args[1] + ", " + args[2] + " or " + args[3] + " is not a valid number!");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "You don't have the permission editarmorstands.command.pose");
                }
            } else {
                player.sendMessage(ChatColor.RED + "Error. You inputted more then 4 arguments!");
            }
        }
        return false;
    }

    public void enablePersistent(Player player) {
        this.persistent.put(player.getUniqueId(), null);
    }

    public void disablePersistent(Player player) {
        this.persistent.remove(player.getUniqueId());
    }

    public boolean isPersistent(Player player) {
        return this.persistent.containsKey(player.getUniqueId());
    }

    public String[] getPersistentAction(Player player) {
        return this.persistent.get(player.getUniqueId());
    }

    public void setPersistentAction(Player player, String[] args) {
        this.persistent.put(player.getUniqueId(), args);
    }

    public void addSelection(Player player, ArmorStand armorStand) {
        this.selectedArmorStands.put(player.getUniqueId(), armorStand.getUniqueId());
    }

    public UUID getSelection(Player player) {
        return this.selectedArmorStands.get(player.getUniqueId());
    }

    public void removeSelection(Player player) {
        this.selectedArmorStands.remove(player.getUniqueId());
    }

    public boolean isSelected(Entity entity) {
        return this.selectedArmorStands.containsValue(entity.getUniqueId());
    }

    public void addWaitingAction(Player player, String[] args) {
        this.waitingCommands.put((Object)player.getUniqueId(), (Object)args);
    }

    public boolean hasWaitingAction(Player player) {
        return this.getWaitingAction(player) != null;
    }

    public String[] getWaitingAction(Player player) {
        return (String[])this.waitingCommands.getIfPresent((Object)player.getUniqueId());
    }

    public void removeWaitingAction(Player player) {
        this.waitingCommands.invalidate((Object)player.getUniqueId());
    }

    public void removeSelected(Entity entity) {
        Iterator<UUID> it = this.selectedArmorStands.values().iterator();
        while (it.hasNext()) {
            if (!entity.getUniqueId().equals(it.next())) continue;
            it.remove();
        }
    }
}

