/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.bungeeplugin;

import de.themoep.bungeeplugin.FileConfiguration;
import de.themoep.bungeeplugin.PluginCommand;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;

public abstract class BungeePlugin
extends Plugin {
    private boolean enabled;
    private FileConfiguration descConfig;
    private FileConfiguration pluginConfig;

    public void onLoad() {
        try {
            this.descConfig = new FileConfiguration((Plugin)this, this.getResourceAsStream("bungee.yml") != null ? "bungee.yml" : "plugin.yml");
            BungeePlugin.removeFromConfig(this.descConfig.getConfiguration(), "name", "main", "version", "author", "depends", "softdepends", "description");
            this.descConfig.saveConfig();
            this.pluginConfig = new FileConfiguration((Plugin)this, "config.yml");
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error while loading plugin. Will not enable!", e);
            this.enabled = false;
        }
        this.enabled = true;
    }

    @Deprecated
    public PluginCommand registerCommand(String name, Class<? extends PluginCommand> commandClass) {
        try {
            Constructor<? extends PluginCommand> constructor = commandClass.getConstructor(BungeePlugin.class, String.class);
            PluginCommand command = constructor.newInstance(new Object[]{this, name});
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)command);
            return command;
        }
        catch (NoSuchMethodException ignored) {
            this.getLogger().log(Level.SEVERE, "Could not find constructor in the command class " + commandClass + "! Disabling plugin!");
            this.enabled = false;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "Could not create new command instance for class " + commandClass + "! Disabling plugin!", e);
            this.enabled = false;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FileConfiguration getConfig() {
        return this.pluginConfig;
    }

    public FileConfiguration getDescriptionConfig() {
        return this.descConfig;
    }

    public static String translate(String message, String ... replacements) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int i = 0;
        while (i + 1 < replacements.length) {
            message = message.replace("%" + replacements[i] + "%", replacements[i + 1]);
            i += 2;
        }
        return message;
    }

    public static void broadcast(String permission, String message, String ... replacements) {
        message = BungeePlugin.translate(message, replacements);
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            if (permission != null && !player.hasPermission(permission)) continue;
            player.sendMessage(message);
        }
    }

    public static void removeFromConfig(Configuration config, String ... paths) {
        for (String path : paths) {
            config.set(path, null);
        }
    }
}

