/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.bungeeplugin;

import de.themoep.bungeeplugin.BungeePlugin;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.md_5.bungee.config.Configuration;

public abstract class PluginCommand
extends Command
implements TabExecutor {
    protected final BungeePlugin plugin;
    private final String permission;
    private final String permissionMessage;
    private final String description;
    private final String usage;
    private final String[] aliases;

    public PluginCommand(BungeePlugin plugin, String name) {
        super(name, null, new String[0]);
        this.plugin = plugin;
        Configuration commandSection = plugin.getDescriptionConfig().getSection("commands." + name);
        if (!commandSection.getKeys().isEmpty()) {
            this.permission = commandSection.getString("permission");
            String permissionMessage = commandSection.getString("permission-message");
            this.permissionMessage = permissionMessage != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)permissionMessage) : "";
            String description = commandSection.getString("description");
            this.description = description != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)description) : "";
            String usage = commandSection.getString("usage");
            this.usage = usage != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)usage) : "/<command>";
            List aliases = commandSection.getStringList("aliases");
            this.aliases = aliases != null ? aliases.toArray(new String[aliases.size()]) : new String[]{};
        } else {
            this.permission = null;
            this.permissionMessage = "";
            this.description = "";
            this.usage = "/<command>";
            this.aliases = new String[0];
        }
    }

    public PluginCommand(BungeePlugin plugin, String name, String permission, String permissionMessage, String description, String usage, String ... aliases) {
        super(name, null, new String[0]);
        this.plugin = plugin;
        this.permission = permission;
        this.aliases = aliases;
        this.permissionMessage = permissionMessage != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)permissionMessage) : "";
        this.description = description != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)description) : "";
        this.usage = usage != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)usage) : "/<command>";
    }

    public void execute(CommandSender sender, String[] args) {
        if (this.getCommandPermission() != null && !sender.hasPermission(this.getCommandPermission())) {
            if (!this.getPermissionMessage().isEmpty()) {
                sender.sendMessage(ChatColor.RED + this.getPermissionMessage().replace("<permission>", this.getCommandPermission()));
            } else {
                sender.sendMessage(this.plugin.getProxy().getTranslation("no_permission", new Object[0]));
            }
            return;
        }
        if (!this.run(sender, args) && !this.getUsage().isEmpty()) {
            sender.sendMessage(ChatColor.RED + this.getUsage().replace("<command>", this.getName()));
        }
    }

    protected abstract boolean run(CommandSender var1, String[] var2);

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        ArrayList<String> tabList = new ArrayList<String>();
        for (ProxiedPlayer p : this.plugin.getProxy().getPlayers()) {
            if (args.length != 0 && !p.getName().toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
            tabList.add(p.getName());
        }
        return tabList;
    }

    public BungeePlugin getPlugin() {
        return this.plugin;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getCommandPermission() {
        return this.permission;
    }

    public String getPermissionMessage() {
        return this.permissionMessage;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }
}

