/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bungee;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.themoep.connectorplugin.BridgeCommon;
import de.themoep.connectorplugin.BridgedCommand;
import de.themoep.connectorplugin.BridgedSuggestions;
import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.ProxyBridgeCommon;
import de.themoep.connectorplugin.ResponseHandler;
import de.themoep.connectorplugin.bungee.BungeeConnectorPlugin;
import de.themoep.connectorplugin.connector.ConnectingPlugin;
import de.themoep.connectorplugin.connector.MessageTarget;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.md_5.bungee.event.EventHandler;

public class Bridge
extends ProxyBridgeCommon<BungeeConnectorPlugin, ProxiedPlayer>
implements Listener {
    private Table<String, String, BridgedCommand<?, CommandSender>> commands = HashBasedTable.create();

    public Bridge(BungeeConnectorPlugin plugin) {
        super((ConnectorPlugin)plugin);
        plugin.getProxy().getPluginManager().registerListener((Plugin)plugin, (Listener)this);
        this.registerMessageHandler("send_to_server", (receiver, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            long id = in.readLong();
            String playerName = in.readUTF();
            String targetServer = in.readUTF();
            ProxiedPlayer player = plugin.getProxy().getPlayer(playerName);
            if (player == null) {
                plugin.logDebug("Could not find player " + playerName + " on this proxy to send to server " + targetServer, new Throwable[0]);
                this.sendResponse(senderServer, id, false, new String[]{"Could not find player " + playerName + " on this proxy to send to server " + targetServer});
                return;
            }
            ServerInfo server = plugin.getProxy().getServerInfo(targetServer);
            if (server == null) {
                plugin.logDebug("Could not find server " + targetServer + " on this proxy to send player " + playerName + " to", new Throwable[0]);
                this.sendResponse(senderServer, id, false, new String[]{"Could not find server " + targetServer + " on this proxy to send player " + playerName + " to"});
                return;
            }
            if (!player.getServer().getInfo().equals(server)) {
                plugin.logDebug("Sending '" + playerName + "' to server '" + targetServer + "'. Triggered from " + senderServer, new Throwable[0]);
                player.connect(server, (success, ex) -> {
                    this.sendResponse(senderServer, id, success, new String[0]);
                    if (ex != null) {
                        this.sendResponseMessage(senderServer, id, new String[]{ex.getMessage()});
                    }
                });
            } else {
                plugin.logDebug("Player '" + playerName + "' is already on server '" + targetServer + "'! Triggered from " + senderServer, new Throwable[0]);
                this.sendResponse(senderServer, id, true, new String[]{playerName + " is already connected to server " + targetServer});
            }
        });
        this.registerMessageHandler("get_location", (receiver, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            long id = in.readLong();
            String playerName = in.readUTF();
            ProxiedPlayer player = plugin.getProxy().getPlayer(playerName);
            if (player != null && player.getServer() != null) {
                this.getLocation(player).thenAccept(location -> this.sendResponse(senderServer, id, location, new String[0]));
            } else {
                this.sendResponse(senderServer, id, "", new String[0]);
            }
        });
        this.registerMessageHandler("player_command", (receiver, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            long id = in.readLong();
            String playerName = in.readUTF();
            UUID playerId = new UUID(in.readLong(), in.readLong());
            String command = in.readUTF();
            ProxiedPlayer player = plugin.getProxy().getPlayer(playerId);
            if (player == null) {
                player = plugin.getProxy().getPlayer(playerName);
            }
            if (player == null) {
                plugin.logDebug("Could not find player " + playerName + "/" + playerId + " on this proxy to execute command " + command, new Throwable[0]);
                this.sendResponse(senderServer, id, false, new String[]{"Could not find player " + playerName + "/" + playerId + " on this proxy to execute command " + command});
                return;
            }
            plugin.logDebug("Command '" + command + "' for player '" + playerName + "' triggered from " + senderServer, new Throwable[0]);
            boolean success = plugin.getProxy().getPluginManager().dispatchCommand((CommandSender)player, command);
            this.sendResponse(player, id, success, new String[0]);
        });
        this.registerMessageHandler("console_command", (receiver, message) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getData());
            String senderServer = message.getReceivedMessage().getSendingServer();
            long id = in.readLong();
            String command = in.readUTF();
            plugin.logDebug("Console command '" + command + "' triggered from " + senderServer, new Throwable[0]);
            boolean success = plugin.getProxy().getPluginManager().dispatchCommand((CommandSender)new BridgedSender(senderServer, id), command);
            this.sendResponse(senderServer, id, success, new String[0]);
        });
        this.registerHandler("execute_command", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String serverName = in.readUTF();
            if (!serverName.equals(plugin.getServerName())) {
                return;
            }
            String senderName = in.readUTF();
            String pluginName = in.readUTF();
            String commandName = in.readUTF();
            Object sender = senderName.isEmpty() ? plugin.getProxy().getConsole() : plugin.getProxy().getPlayer(senderName);
            if (sender == null) {
                plugin.logDebug("Could not find player " + senderName + " for execution of command " + commandName + " for plugin " + pluginName, new Throwable[0]);
                return;
            }
            BridgedCommand command = (BridgedCommand)this.commands.get((Object)pluginName.toLowerCase(Locale.ROOT), (Object)commandName.toLowerCase(Locale.ROOT));
            if (command == null) {
                plugin.logDebug("Could not find executor for command " + commandName + " for plugin " + pluginName, new Throwable[0]);
                return;
            }
            String commandLabel = in.readUTF();
            int argsCount = in.readInt();
            String[] args = new String[argsCount];
            for (int i = 0; i < argsCount; ++i) {
                args[i] = in.readUTF();
            }
            LocationInfo location = null;
            if (sender instanceof ProxiedPlayer) {
                location = LocationInfo.read((ByteArrayDataInput)in);
            }
            try {
                if (!command.onCommand(sender, location, commandLabel, args) && command.getUsage().length() > 0) {
                    for (String line : command.getUsage().replace("<command>", commandLabel).split("\n")) {
                        sender.sendMessage(line);
                    }
                }
            }
            catch (Throwable ex) {
                plugin.logError("Unhandled exception executing bridged command '" + commandLabel + "' from plugin " + command.getPlugin().getName(), ex);
            }
        });
    }

    private void sendResponse(ProxiedPlayer player, long id, boolean success, String ... messages) {
        this.sendResponse("player:" + player.getName(), id, success, messages);
    }

    public CompletableFuture<Boolean> teleport(ProxiedPlayer player, LocationInfo location, Consumer<String> ... consumer) {
        return this.teleport(player.getName(), location, consumer);
    }

    public CompletableFuture<Boolean> teleport(String playerName, LocationInfo location, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ProxiedPlayer player = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(playerName);
        if (player == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find player " + playerName + " on this proxy to send to teleport to " + location, new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find player " + playerName + " on this proxy to teleport to " + location);
            }
            return future;
        }
        ServerInfo server = ((BungeeConnectorPlugin)this.plugin).getProxy().getServerInfo(location.getServer());
        if (server == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find server " + location.getServer() + " on this proxy to teleport player " + player.getName() + " to", new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find server " + location.getServer() + " on this proxy to teleport player " + player.getName() + " to");
            }
            return future;
        }
        this.markTeleporting(playerName);
        future.thenAccept(success -> this.unmarkTeleporting(playerName));
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getName());
        location.write(out);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        this.sendData("teleport", MessageTarget.SERVER, server.getName(), out.toByteArray());
        this.sendToServerIfNecessary(player, server, future, consumer);
        return future;
    }

    public CompletableFuture<Boolean> teleport(ProxiedPlayer player, String serverName, String worldName, Consumer<String> ... consumer) {
        return this.teleport(player.getName(), serverName, worldName, consumer);
    }

    public CompletableFuture<Boolean> teleport(String playerName, String serverName, String worldName, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ProxiedPlayer player = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(playerName);
        if (player == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find player " + playerName + " on this proxy to send to teleport to " + serverName + "/" + worldName, new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find player " + playerName + " on this proxy to teleport to " + serverName + "/" + worldName);
            }
            return future;
        }
        ServerInfo server = ((BungeeConnectorPlugin)this.plugin).getProxy().getServerInfo(serverName);
        if (server == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find server " + serverName + " on this proxy to teleport player " + player.getName() + " to", new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find server " + serverName + " on this proxy to teleport player " + player.getName() + " to");
            }
            return future;
        }
        this.markTeleporting(playerName);
        future.thenAccept(success -> this.unmarkTeleporting(playerName));
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getName());
        out.writeUTF(serverName);
        out.writeUTF(worldName);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        this.sendData("teleport_to_world", MessageTarget.SERVER, server.getName(), out.toByteArray());
        this.sendToServerIfNecessary(player, server, future, consumer);
        return future;
    }

    public CompletableFuture<Boolean> teleport(ProxiedPlayer player, ProxiedPlayer target, Consumer<String> ... consumer) {
        return this.teleport(player.getName(), target.getName(), consumer);
    }

    public CompletableFuture<Boolean> teleport(String playerName, String targetName, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ProxiedPlayer player = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(playerName);
        if (player == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find player " + playerName + " on this proxy to send to teleport to " + targetName, new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find player " + playerName + " on this proxy to teleport to " + targetName);
            }
            return future;
        }
        this.getServer(targetName).thenAccept(serverName -> {
            if (serverName == null || serverName.isEmpty()) {
                ((BungeeConnectorPlugin)this.plugin).logDebug("Target player " + targetName + " is either not online or not connected to a server. (Tried to teleport " + player.getName() + " to them)", new Throwable[0]);
                future.complete(false);
                for (Consumer c : consumer) {
                    c.accept("Could not find target player " + targetName + " to teleport " + player.getName() + " to");
                }
                return;
            }
            ServerInfo server = ((BungeeConnectorPlugin)this.plugin).getProxy().getServerInfo(serverName);
            if (server == null) {
                ((BungeeConnectorPlugin)this.plugin).logDebug("Target player " + targetName + " is online on server " + serverName + " which does not exist on this proxy! (Tried to teleport " + player.getName() + " to them)", new Throwable[0]);
                future.complete(false);
                for (Consumer c : consumer) {
                    c.accept("Could not find server " + serverName + " of target player " + targetName + " on " + player.getName() + "'s proxy to teleport them");
                }
                return;
            }
            this.markTeleporting(playerName);
            future.thenAccept(success -> this.unmarkTeleporting(playerName));
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            long id = RANDOM.nextLong();
            out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
            out.writeLong(id);
            out.writeUTF(player.getName());
            out.writeUTF(targetName);
            this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
            this.consumers.put((Object)id, (Object)consumer);
            this.sendData("teleport_to_player", MessageTarget.ALL_QUEUE, out.toByteArray());
            this.sendToServerIfNecessary(player, server, future, consumer);
        });
        return future;
    }

    private void sendToServerIfNecessary(ProxiedPlayer player, ServerInfo server, CompletableFuture<Boolean> future, Consumer<String> ... consumer) {
        if (!player.getServer().getInfo().equals(server) && ((BungeeConnectorPlugin)this.plugin).getConnector().requiresPlayer() && server.getPlayers().isEmpty()) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Sending '" + player.getName() + "' to server '" + server.getName() + "'", new Throwable[0]);
            player.connect(server, (success, ex) -> {
                if (!success.booleanValue()) {
                    future.complete(false);
                    if (ex != null) {
                        for (Consumer c : consumer) {
                            c.accept(ex.getMessage());
                        }
                    }
                }
            });
        }
    }

    public CompletableFuture<LocationInfo> getLocation(ProxiedPlayer player) {
        return this.getLocation(player.getName());
    }

    public CompletableFuture<String> getServer(ProxiedPlayer player) {
        return this.getServer(player.getName());
    }

    public CompletableFuture<Boolean> runServerPlayerCommand(ProxiedPlayer player, String command) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getName());
        out.writeLong(player.getUniqueId().getMostSignificantBits());
        out.writeLong(player.getUniqueId().getLeastSignificantBits());
        out.writeUTF(command);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.sendData("player_command", MessageTarget.SERVER, player, out.toByteArray());
        return future;
    }

    public void registerServerCommand(String server, BridgedCommand<?, CommandSender> command) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        this.write(out, command);
        this.sendData("register_command", MessageTarget.SERVER, server, out.toByteArray());
    }

    protected void registerServerCommands(String server) {
        for (BridgedCommand command : this.commands.values()) {
            this.registerServerCommand(server, command);
        }
    }

    public void registerServerCommand(BridgedCommand<? extends Plugin, CommandSender> command) {
        this.commands.put((Object)((ConnectingPlugin)((Plugin)command.getPlugin())).getName().toLowerCase(Locale.ROOT), (Object)command.getName().toLowerCase(Locale.ROOT), command);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        this.write(out, command);
        this.sendData("register_command", MessageTarget.ALL_QUEUE, out.toByteArray());
        ((BungeeConnectorPlugin)this.plugin).getProxy().getPluginManager().registerCommand((Plugin)command.getPlugin(), (Command)new ForwardingCommand(command.getName(), command.getPermission(), command));
        for (String alias : command.getAliases()) {
            ((BungeeConnectorPlugin)this.plugin).getProxy().getPluginManager().registerCommand((Plugin)command.getPlugin(), (Command)new ForwardingCommand(alias, command.getPermission(), command));
        }
    }

    private void write(ByteArrayDataOutput out, BridgedCommand<?, CommandSender> command) {
        out.writeUTF(command.getPlugin().getName());
        out.writeUTF(command.getName());
        out.writeUTF(command.getDescription() != null ? command.getDescription() : "");
        out.writeUTF(command.getUsage() != null ? command.getUsage() : "");
        out.writeUTF(command.getPermission() != null ? command.getPermission() : "");
        if (command.getPermissionMessage() != null) {
            out.writeBoolean(true);
            out.writeUTF(command.getPermissionMessage());
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(command.getAliases().length);
        for (String alias : command.getAliases()) {
            out.writeUTF(alias);
        }
    }

    @EventHandler(priority=-128)
    public void onPlayerJoin(ServerConnectEvent event) {
        if (event.getPlayer().getServer() == null) {
            this.unmarkTeleporting(event.getPlayer().getName());
        }
        if (!event.isCancelled()) {
            this.onPlayerJoin(new BridgeCommon.PlayerInfo(event.getPlayer().getUniqueId(), event.getPlayer().getName(), event.getTarget().getName()));
        }
    }

    @EventHandler(priority=-128)
    public void onPlayerQuit(PlayerDisconnectEvent event) {
        this.onPlayerLeave(event.getPlayer().getName());
    }

    private class ForwardingCommand
    extends Command
    implements TabExecutor {
        private final BridgedCommand<? extends Plugin, CommandSender> command;

        public ForwardingCommand(String name, String permission, BridgedCommand<? extends Plugin, CommandSender> command) {
            super(name, permission, new String[0]);
            this.command = command;
        }

        public void execute(CommandSender sender, String[] args) {
            if (sender instanceof ProxiedPlayer) {
                Bridge.this.runServerPlayerCommand((ProxiedPlayer)sender, this.getName() + " " + String.join((CharSequence)" ", args));
            } else {
                this.command.onCommand((Object)sender, null, this.getName(), args);
            }
        }

        public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
            if (this.command instanceof BridgedSuggestions && sender.hasPermission(this.command.getPermission() + ".tabcomplete." + this.getName())) {
                return ((BridgedSuggestions)this.command).suggest((Object)sender, this.getName(), args);
            }
            return Collections.emptySet();
        }
    }

    private class BridgedSender
    implements CommandSender {
        private final String serverName;
        private final long id;

        public BridgedSender(String serverName, long id) {
            this.serverName = serverName;
            this.id = id;
        }

        public String getName() {
            return this.serverName + "BridgedSender";
        }

        public void sendMessage(String message) {
            this.sendMessages(message);
        }

        public void sendMessages(String ... messages) {
            Bridge.this.sendResponseMessage(this.serverName, this.id, messages);
        }

        public void sendMessage(BaseComponent ... message) {
            this.sendMessage(TextComponent.toLegacyText((BaseComponent[])message));
        }

        public void sendMessage(BaseComponent message) {
            this.sendMessage(TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{message}));
        }

        public Collection<String> getGroups() {
            return null;
        }

        public void addGroups(String ... groups) {
        }

        public void removeGroups(String ... groups) {
        }

        public boolean hasPermission(String permission) {
            return true;
        }

        public void setPermission(String permission, boolean value) {
        }

        public Collection<String> getPermissions() {
            return Collections.emptySet();
        }
    }
}

