/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bungee.commands;

import de.themoep.connectorplugin.bungee.BungeeConnectorPlugin;
import de.themoep.connectorplugin.bungee.commands.ConnectorCommand;
import de.themoep.connectorplugin.bungee.commands.SubCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class ServerConsoleCommand
extends SubCommand {
    public ServerConsoleCommand(ConnectorCommand parent) {
        super((BungeeConnectorPlugin)parent.getPlugin(), "servercommand <servername|p:player> <command...>", parent.getPermission() + ".servercommand", "serverconsole", "serverconsolecommand", "server", "scc");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean run(CommandSender sender, String[] args) {
        if (args.length < 2) {
            return false;
        }
        String serverName = args[0];
        if (serverName.startsWith("p:")) {
            ProxiedPlayer player = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(serverName.substring(2));
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "The player '" + serverName.substring(2) + "' is not online?");
                return false;
            }
            if (player.getServer() == null) {
                sender.sendMessage(ChatColor.RED + "Player '" + player.getName() + "' is not connected to any server?");
                return false;
            }
            serverName = player.getServer().getInfo().getName();
        } else if (((BungeeConnectorPlugin)this.plugin).getProxy().getServerInfo(serverName) == null) {
            sender.sendMessage(ChatColor.GRAY + "There is no server with the name of '" + serverName + "' on the proxy. Trying to send command anyways...");
        }
        String commandString = Arrays.stream(args).skip(1L).collect(Collectors.joining(" "));
        sender.sendMessage(ChatColor.GRAY + "Executing '" + commandString + "' on server '" + serverName + "'");
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
        ((BungeeConnectorPlugin)this.plugin).getBridge().runServerConsoleCommand(serverName, commandString, consumerArray).thenAccept(success -> sender.sendMessage(success != false ? "Successfully executed command!" : "Error while executing the command."));
        return true;
    }

    @Override
    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptySet();
        }
        if (args.length == 0) {
            return ((BungeeConnectorPlugin)this.plugin).getProxy().getServers().keySet();
        }
        if (args.length == 1) {
            return ((BungeeConnectorPlugin)this.plugin).getProxy().getServers().keySet().stream().filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        return Collections.emptySet();
    }
}

