/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bungee.commands;

import de.themoep.connectorplugin.bungee.BungeeConnectorPlugin;
import de.themoep.connectorplugin.bungee.commands.ConnectorCommand;
import de.themoep.connectorplugin.bungee.commands.SubCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class ServerPlayerCommand
extends SubCommand {
    public ServerPlayerCommand(ConnectorCommand parent) {
        super((BungeeConnectorPlugin)parent.getPlugin(), "serverplayercommand <playername> <command...>", parent.getPermission() + ".serverplayercommand", "serverplayer", "player", "spc");
    }

    @Override
    public boolean run(CommandSender sender, String[] args) {
        if (args.length < 2) {
            return false;
        }
        ProxiedPlayer player = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage("No player with the name " + args[0] + " is online on this server!");
            return true;
        }
        String commandString = Arrays.stream(args).skip(1L).collect(Collectors.joining(" "));
        sender.sendMessage(ChatColor.GRAY + "Executing '" + commandString + "' on the server for player '" + player.getName() + "'");
        ((BungeeConnectorPlugin)this.plugin).getBridge().runServerPlayerCommand(player, commandString).thenAccept(success -> sender.sendMessage(success != false ? "Successfully executed command!" : "Error while executing the command."));
        return true;
    }

    @Override
    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptySet();
        }
        if (args.length == 0) {
            return ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayers().stream().map(CommandSender::getName).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        if (args.length == 1) {
            return ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayers().stream().map(CommandSender::getName).filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        return Collections.emptySet();
    }
}

