/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bungee.commands;

import de.themoep.connectorplugin.bungee.BungeeConnectorPlugin;
import de.themoep.connectorplugin.bungee.commands.ConnectorCommand;
import de.themoep.connectorplugin.bungee.commands.SubCommand;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class TeleportToPlayerCommand
extends SubCommand {
    public TeleportToPlayerCommand(ConnectorCommand parent) {
        super((BungeeConnectorPlugin)parent.getPlugin(), "teleporttoplayer <player> [<target>]", parent.getPermission() + ".teleporttoplayer", "teleportplayer");
    }

    @Override
    public boolean run(CommandSender sender, String[] args) {
        String targetName;
        String playerName;
        if (args.length == 1 && sender instanceof ProxiedPlayer) {
            playerName = sender.getName();
            targetName = args[0];
        } else if (args.length == 2) {
            playerName = args[0];
            targetName = args[1];
        } else {
            return false;
        }
        ProxiedPlayer player = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "No player with the name " + playerName + " found!");
            return true;
        }
        ProxiedPlayer target = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(targetName);
        if (target == null) {
            sender.sendMessage(ChatColor.RED + "No player with the name " + targetName + " found!");
            return true;
        }
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
        ((BungeeConnectorPlugin)this.plugin).getBridge().teleport(player.getName(), target.getName(), consumerArray).thenAccept(success -> {
            if (!success.booleanValue()) {
                sender.sendMessage(ChatColor.RED + "Error while teleporting...");
            }
        });
        return true;
    }

    @Override
    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptySet();
        }
        if (args.length == 0) {
            return ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayers().stream().map(CommandSender::getName).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        if (args.length == 1) {
            return ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayers().stream().map(CommandSender::getName).filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayers().stream().map(CommandSender::getName).filter(s -> s.startsWith(args[1].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        return Collections.emptySet();
    }
}

