/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.ByteArrayDataInput;
import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.ResponseHandler;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class BridgeCommon<P extends ConnectorPlugin> {
    protected final P plugin;
    protected final Cache<Long, ResponseHandler<?>> responses = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    protected final Cache<Long, Consumer<String>[]> consumers = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();
    protected static final Random RANDOM = new Random();

    public BridgeCommon(P plugin) {
        this.plugin = plugin;
        if (plugin.getConnector().requiresPlayer()) {
            plugin.logWarning("The configured messenger type " + plugin.getConnector().getClass().getSimpleName().replace("Connector", "") + " requires at least one player connected to the sending and receiving server, some functionality might not work the best! Please consider using a different messenger type.", new Throwable[0]);
        }
    }

    protected void handleResponse(long id, ByteArrayDataInput in) {
        ResponseHandler responseHandler = (ResponseHandler)this.responses.getIfPresent((Object)id);
        if (responseHandler != null) {
            this.responses.invalidate((Object)id);
            if (responseHandler instanceof ResponseHandler.Boolean) {
                ((ResponseHandler.Boolean)responseHandler).getFuture().complete(in.readBoolean());
            } else if (responseHandler instanceof ResponseHandler.Location) {
                ((ResponseHandler.Location)responseHandler).getFuture().complete(LocationInfo.read(in));
            } else {
                this.plugin.logDebug("Response handler type " + responseHandler + " is not supported for ID " + id, new Throwable[0]);
            }
        } else {
            this.plugin.logDebug("Could not find response for execution with ID " + id, new Throwable[0]);
        }
    }

    public static class Action {
        public static final String STARTED = "started";
        public static final String SEND_TO_SERVER = "send_to_server";
        public static final String TELEPORT = "teleport";
        public static final String TELEPORT_TO_WORLD = "teleport_to_world";
        public static final String TELEPORT_TO_PLAYER = "teleport_to_player";
        public static final String GET_LOCATION = "get_location";
        public static final String PLAYER_COMMAND = "player_command";
        public static final String CONSOLE_COMMAND = "console_command";
        public static final String RESPONSE = "response";
        public static final String REGISTER_COMMAND = "register_command";
        public static final String EXECUTE_COMMAND = "execute_command";
    }
}

