/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;

public class LocationInfo {
    private final String server;
    private final String world;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;

    public LocationInfo(String server, String world, double x, double y, double z) {
        this(server, world, x, y, z, 0.0f, 0.0f);
    }

    public LocationInfo(String server, String world, double x, double y, double z, float yaw, float pitch) {
        this.server = server;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public LocationInfo(LocationInfo location) {
        this(location.getServer(), location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public String getServer() {
        return this.server;
    }

    public String getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void write(ByteArrayDataOutput out) {
        out.writeUTF(this.getServer());
        out.writeUTF(this.getWorld());
        out.writeDouble(this.getX());
        out.writeDouble(this.getY());
        out.writeDouble(this.getZ());
        out.writeFloat(this.getPitch());
        out.writeFloat(this.getYaw());
    }

    public static LocationInfo read(ByteArrayDataInput in) {
        String serverName = in.readUTF();
        if (serverName.isEmpty()) {
            return null;
        }
        return new LocationInfo(serverName, in.readUTF(), in.readDouble(), in.readDouble(), in.readDouble(), in.readFloat(), in.readFloat());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{server=" + this.getServer() + ",world=" + this.getWorld() + ",x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + ",yaw=" + this.getYaw() + ",pitch=" + this.getPitch() + "}";
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof LocationInfo)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        LocationInfo other = (LocationInfo)o;
        return other.getServer().equalsIgnoreCase(this.getServer()) && (other.getWorld() == null && this.getWorld() == null || other.getWorld() != null && other.getWorld().equalsIgnoreCase(this.getWorld())) && other.getX() == this.getX() && other.getY() == this.getY() && other.getZ() == this.getZ() && other.getYaw() == this.getYaw() && other.getPitch() == this.getPitch();
    }
}

