/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bukkit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.themoep.connectorplugin.BridgeCommon;
import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.ResponseHandler;
import de.themoep.connectorplugin.bukkit.BukkitConnectorPlugin;
import de.themoep.connectorplugin.connector.ConnectingPlugin;
import de.themoep.connectorplugin.connector.MessageTarget;
import de.themoep.connectorplugin.lib.paperlib.PaperLib;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class Bridge
extends BridgeCommon<BukkitConnectorPlugin>
implements Listener {
    private CommandMap commandMap = null;
    private Cache<String, LoginRequest> loginRequests = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public Bridge(BukkitConnectorPlugin plugin) {
        super(plugin);
        try {
            Field commandMapField = SimplePluginManager.class.getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            this.commandMap = (CommandMap)commandMapField.get(plugin.getServer().getPluginManager());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        plugin.getConnector().registerHandler(plugin, "teleport", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            LocationInfo location = LocationInfo.read(in);
            if (!location.getServer().equals(plugin.getServerName())) {
                return;
            }
            if (plugin.getServer().getWorld(location.getWorld()) == null) {
                this.sendResponse(senderServer, id, false, "No world with the name " + location.getWorld() + " exists on the server " + location.getServer() + "!");
                return;
            }
            Player player = plugin.getServer().getPlayer(playerName);
            if (player != null) {
                PaperLib.teleportAsync((Entity)player, this.toBukkit(location)).whenComplete((success, ex) -> this.sendResponse(senderServer, id, success, success != false ? "Player teleported!" : "Unable to teleport " + (ex != null ? ex.getMessage() : "")));
            } else {
                this.loginRequests.put((Object)playerName.toLowerCase(Locale.ROOT), (Object)new LocationTeleportRequest(senderServer, id, location));
                if (!plugin.getConnector().requiresPlayer() || !plugin.getServer().getOnlinePlayers().isEmpty()) {
                    plugin.getBridge().sendToServer(playerName, location.getServer(), messages -> this.sendResponseMessage(senderServer, id, (String)messages)).whenComplete((success, ex) -> this.sendResponse(senderServer, id, success, success != false ? "Player teleported!" : "Unable to teleport " + (ex != null ? ex.getMessage() : "")));
                }
            }
        });
        plugin.getConnector().registerHandler(plugin, "teleport_to_world", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            String serverName = in.readUTF();
            if (!serverName.equals(plugin.getServerName())) {
                return;
            }
            String worldName = in.readUTF();
            World world = plugin.getServer().getWorld(worldName);
            if (world == null) {
                this.sendResponse(senderServer, id, false, "No world with the name " + worldName + " exists on the server!");
                return;
            }
            Player player = plugin.getServer().getPlayer(playerName);
            if (player != null) {
                PaperLib.teleportAsync((Entity)player, world.getSpawnLocation()).whenComplete((success, ex) -> this.sendResponse(senderServer, id, success, success != false ? "Player teleported to spawn of " + worldName + "!" : "Unable to teleport " + (ex != null ? ex.getMessage() : "")));
            } else {
                this.loginRequests.put((Object)playerName.toLowerCase(Locale.ROOT), (Object)new LocationTeleportRequest(senderServer, id, this.fromBukkit(world.getSpawnLocation())));
                if (!plugin.getConnector().requiresPlayer() || !plugin.getServer().getOnlinePlayers().isEmpty()) {
                    plugin.getBridge().sendToServer(playerName, serverName, messages -> this.sendResponseMessage(senderServer, id, (String)messages)).whenComplete((success, ex) -> this.sendResponse(senderServer, id, success, success != false ? "Player teleported to spawn of " + worldName + "!" : "Unable to teleport " + (ex != null ? ex.getMessage() : "")));
                }
            }
        });
        plugin.getConnector().registerHandler(plugin, "teleport_to_player", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            String targetName = in.readUTF();
            Player target = plugin.getServer().getPlayer(targetName);
            if (target != null) {
                Player player = plugin.getServer().getPlayer(playerName);
                if (player != null) {
                    PaperLib.teleportAsync((Entity)player, target.getLocation()).whenComplete((success, ex) -> this.sendResponse(senderServer, id, success, success != false ? "Player teleported!" : "Unable to teleport " + (ex != null ? ex.getMessage() : "")));
                } else {
                    this.loginRequests.put((Object)playerName.toLowerCase(Locale.ROOT), (Object)new PlayerTeleportRequest(senderServer, id, targetName));
                    if (!plugin.getConnector().requiresPlayer() || !plugin.getServer().getOnlinePlayers().isEmpty()) {
                        plugin.getBridge().sendToServer(playerName, plugin.getServerName(), messages -> this.sendResponseMessage(senderServer, id, (String)messages)).whenComplete((success, ex) -> this.sendResponse(senderServer, id, success, success != false ? "Player teleported!" : "Unable to teleport " + (ex != null ? ex.getMessage() : "")));
                    }
                }
            }
        });
        plugin.getConnector().registerHandler(plugin, "get_location", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            Player player = plugin.getServer().getPlayer(playerName);
            if (player != null) {
                this.sendResponse(senderServer, id, this.fromBukkit(player.getLocation()), new String[0]);
            } else {
                this.sendResponse(senderServer, id, null, new String[0]);
            }
        });
        plugin.getConnector().registerHandler(plugin, "player_command", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            UUID playerId = new UUID(in.readLong(), in.readLong());
            String command = in.readUTF();
            Player player = plugin.getServer().getPlayer(playerId);
            if (player == null) {
                player = plugin.getServer().getPlayer(playerName);
            }
            if (player == null) {
                plugin.logDebug("Could not find player " + playerName + "/" + playerId + " on this server to execute command " + command, new Throwable[0]);
                this.sendResponse(senderServer, id, false, "Could not find player " + playerName + "/" + playerId + " on this server to execute command " + command);
                return;
            }
            plugin.logDebug("Command '" + command + "' for player '" + playerName + "' triggered from " + senderServer, new Throwable[0]);
            boolean success = plugin.getServer().dispatchCommand((CommandSender)player, command);
            this.sendResponse(senderServer, id, success, new String[0]);
        });
        plugin.getConnector().registerHandler(plugin, "console_command", (receiver, data) -> {
            Player player;
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            String targetServer = in.readUTF();
            if (targetServer.startsWith("p:") ? (player = plugin.getServer().getPlayer(targetServer.substring(2))) == null : !targetServer.equals(plugin.getServerName())) {
                return;
            }
            long id = in.readLong();
            String command = in.readUTF();
            plugin.logDebug("Console command '" + command + "' triggered from " + senderServer, new Throwable[0]);
            boolean success = plugin.getServer().dispatchCommand((CommandSender)new BridgedSender(senderServer, id), command);
            this.sendResponse(senderServer, id, success, new String[0]);
        });
        plugin.getConnector().registerHandler(plugin, "register_command", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            String pluginName = in.readUTF();
            String name = in.readUTF();
            if (this.commandMap != null) {
                String description = in.readUTF();
                String usage = in.readUTF();
                String permission = in.readUTF();
                String permissionMessage = in.readBoolean() ? in.readUTF() : null;
                int aliasCount = in.readInt();
                ArrayList<String> aliases = new ArrayList<String>();
                for (int i = 0; i < aliasCount; ++i) {
                    aliases.add(in.readUTF());
                }
                this.commandMap.register(pluginName, (Command)new BridgedCommandExecutor(senderServer, pluginName, name, description, usage, aliases, permission, permissionMessage));
                plugin.logDebug("Registered command " + name + " by plugin " + pluginName + " from " + senderServer, new Throwable[0]);
            } else {
                plugin.logError("Unable to register proxy command " + name + " for plugin " + pluginName + " due to missing command map access!", new Throwable[0]);
            }
        });
        plugin.getConnector().registerHandler(plugin, "response", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String serverName = in.readUTF();
            if (!serverName.equals(plugin.getServerName())) {
                return;
            }
            long id = in.readLong();
            boolean isCompletion = in.readBoolean();
            if (isCompletion) {
                this.handleResponse(id, in);
            } else {
                String message = in.readUTF();
                Consumer[] consumer = (Consumer[])this.consumers.getIfPresent((Object)id);
                if (consumer != null) {
                    for (Consumer stringConsumer : consumer) {
                        stringConsumer.accept(message);
                    }
                }
            }
        });
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(plugin.getServerName());
        plugin.getConnector().sendData(plugin, "started", MessageTarget.ALL_PROXIES, out.toByteArray());
    }

    @EventHandler
    public void onSpawnLocationEvent(PlayerSpawnLocationEvent event) {
        LoginRequest request = (LoginRequest)this.loginRequests.getIfPresent((Object)event.getPlayer().getName().toLowerCase(Locale.ROOT));
        if (request != null) {
            this.loginRequests.invalidate((Object)event.getPlayer().getName().toLowerCase(Locale.ROOT));
            if (request instanceof LocationTeleportRequest) {
                event.setSpawnLocation(this.toBukkit(((LocationTeleportRequest)request).location));
                this.sendResponse(request.server, request.id, true, "Player login location changed");
            } else if (request instanceof PlayerTeleportRequest) {
                Player target = ((BukkitConnectorPlugin)this.plugin).getServer().getPlayer(((PlayerTeleportRequest)request).targetName);
                if (target == null) {
                    event.setSpawnLocation(((World)((BukkitConnectorPlugin)this.plugin).getServer().getWorlds().get(0)).getSpawnLocation());
                    this.sendResponse(request.server, request.id, false, "Target player " + ((PlayerTeleportRequest)request).targetName + " is no longer online?");
                } else {
                    event.setSpawnLocation(target.getLocation());
                    this.sendResponse(request.server, request.id, true, "Player login location changed to " + target.getName() + "'s location");
                }
            }
        }
    }

    private Location toBukkit(LocationInfo location) {
        World world = ((BukkitConnectorPlugin)this.plugin).getServer().getWorld(location.getWorld());
        if (world == null) {
            throw new IllegalArgumentException("No world with the name " + location.getWorld() + " exists!");
        }
        return new Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    private LocationInfo fromBukkit(Location location) {
        if (location.getWorld() == null) {
            return null;
        }
        return new LocationInfo(((BukkitConnectorPlugin)this.plugin).getServerName(), location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    private void sendResponse(String server, long id, Object response, String ... messages) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(server);
        out.writeLong(id);
        out.writeBoolean(true);
        if (response instanceof Boolean) {
            out.writeBoolean(((Boolean)response).booleanValue());
        } else if (response instanceof LocationInfo) {
            ((LocationInfo)response).write(out);
        } else if (response == null) {
            out.writeUTF("");
        }
        ((BukkitConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "response", server.startsWith("proxy:") ? MessageTarget.ALL_PROXIES : MessageTarget.OTHERS_QUEUE, out.toByteArray());
        if (messages.length > 0) {
            this.sendResponseMessage(server, id, messages);
        }
    }

    private void sendResponseMessage(String server, long id, String ... messages) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(server);
        out.writeLong(id);
        out.writeBoolean(false);
        out.writeUTF(String.join((CharSequence)"\n", messages));
        ((BukkitConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "response", server.startsWith("proxy:") ? MessageTarget.ALL_PROXIES : MessageTarget.OTHERS_QUEUE, out.toByteArray());
    }

    private void sendCommandExecution(CommandSender sender, BridgedCommandExecutor executor, String label, String[] args) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(executor.getServer());
        out.writeUTF(sender instanceof Player ? sender.getName() : "");
        out.writeUTF(executor.getPluginName());
        out.writeUTF(executor.getName());
        out.writeUTF(label);
        out.writeInt(args.length);
        for (String arg : args) {
            out.writeUTF(arg);
        }
        if (sender instanceof Player) {
            this.fromBukkit(((Player)sender).getLocation()).write(out);
            ((BukkitConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "execute_command", MessageTarget.PROXY, (Player)sender, out.toByteArray());
        } else {
            out.writeUTF("");
            ((BukkitConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "execute_command", MessageTarget.ALL_PROXIES, out.toByteArray());
        }
    }

    public CompletableFuture<Boolean> sendToServer(String playerName, String serverName, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BukkitConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(playerName);
        out.writeUTF(serverName);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        ((BukkitConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "send_to_server", MessageTarget.ALL_PROXIES, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> teleport(String playerName, LocationInfo location, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BukkitConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(playerName);
        location.write(out);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        ((BukkitConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "teleport", MessageTarget.ALL_PROXIES, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> teleport(String playerName, String serverName, String worldName, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BukkitConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(playerName);
        out.writeUTF(serverName);
        out.writeUTF(worldName);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        ((BukkitConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "teleport_to_world", MessageTarget.ALL_PROXIES, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> teleport(String playerName, String targetName, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BukkitConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(playerName);
        out.writeUTF(targetName);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        ((BukkitConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "teleport_to_player", MessageTarget.ALL_PROXIES, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> runProxyPlayerCommand(Player player, String command) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BukkitConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getName());
        out.writeLong(player.getUniqueId().getMostSignificantBits());
        out.writeLong(player.getUniqueId().getLeastSignificantBits());
        out.writeUTF(command);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        ((BukkitConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "player_command", MessageTarget.PROXY, player, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> runServerConsoleCommand(String server, String command, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BukkitConnectorPlugin)this.plugin).getServerName());
        out.writeUTF(server);
        out.writeLong(id);
        out.writeUTF(command);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        if (consumer != null && consumer.length > 0) {
            this.consumers.put((Object)id, consumer);
        }
        ((BukkitConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "console_command", MessageTarget.OTHERS_QUEUE, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> runProxyConsoleCommand(String command, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BukkitConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(command);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        if (consumer != null && consumer.length > 0) {
            this.consumers.put((Object)id, consumer);
        }
        ((BukkitConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "console_command", MessageTarget.ALL_PROXIES, out.toByteArray());
        return future;
    }

    private class BridgedCommandExecutor
    extends Command {
        private final String server;
        private final String pluginName;

        public BridgedCommandExecutor(String server, String pluginName, String name, String description, String usage, List<String> aliases, String permission, String permissionMessage) {
            super(name, description, usage, aliases);
            this.server = server;
            this.pluginName = pluginName;
            this.setPermission(permission);
            this.setPermissionMessage(permissionMessage);
        }

        public boolean execute(CommandSender sender, String label, String[] args) {
            if (!this.testPermission(sender)) {
                return true;
            }
            Bridge.this.sendCommandExecution(sender, this, label, args);
            return true;
        }

        public String getServer() {
            return this.server;
        }

        public String getPluginName() {
            return this.pluginName;
        }
    }

    private static class LoginRequest {
        private final String server;
        private final long id;

        private LoginRequest(String server, long id) {
            this.server = server;
            this.id = id;
        }
    }

    private static class LocationTeleportRequest
    extends LoginRequest {
        private final LocationInfo location;

        public LocationTeleportRequest(String server, long id, LocationInfo location) {
            super(server, id);
            this.location = location;
        }
    }

    private static class PlayerTeleportRequest
    extends LoginRequest {
        private final String targetName;

        public PlayerTeleportRequest(String server, long id, String targetName) {
            super(server, id);
            this.targetName = targetName;
        }
    }

    private class BridgedSender
    implements ConsoleCommandSender {
        private final String serverName;
        private final long id;

        public BridgedSender(String serverName, long id) {
            this.serverName = serverName;
            this.id = id;
        }

        public void sendMessage(String message) {
            this.sendMessage(new String[]{message});
        }

        public void sendMessage(String[] messages) {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(this.serverName);
            out.writeLong(this.id);
            out.writeBoolean(false);
            out.writeUTF(String.join((CharSequence)"\n", messages));
            ((BukkitConnectorPlugin)Bridge.this.plugin).getConnector().sendData(Bridge.this.plugin, "response", MessageTarget.OTHERS_QUEUE, out.toByteArray());
        }

        public void sendMessage(UUID sender, String message) {
            this.sendMessage(message);
        }

        public void sendMessage(UUID sender, String[] messages) {
            this.sendMessage(messages);
        }

        public Server getServer() {
            return ((BukkitConnectorPlugin)Bridge.this.plugin).getServer();
        }

        public String getName() {
            return this.serverName + "BridgedSender";
        }

        public CommandSender.Spigot spigot() {
            return new CommandSender.Spigot(){

                public void sendMessage(BaseComponent component) {
                    BridgedSender.this.sendMessage(TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{component}));
                }

                public void sendMessage(BaseComponent ... components) {
                    BridgedSender.this.sendMessage(TextComponent.toLegacyText((BaseComponent[])components));
                }
            };
        }

        public boolean isConversing() {
            return false;
        }

        public void acceptConversationInput(String input) {
        }

        public boolean beginConversation(Conversation conversation) {
            return false;
        }

        public void abandonConversation(Conversation conversation) {
        }

        public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        }

        public void sendRawMessage(String message) {
            this.sendMessage(message);
        }

        public void sendRawMessage(UUID sender, String message) {
            this.sendMessage(message);
        }

        public boolean isPermissionSet(String name) {
            return false;
        }

        public boolean isPermissionSet(Permission perm) {
            return false;
        }

        public boolean hasPermission(String name) {
            return true;
        }

        public boolean hasPermission(Permission perm) {
            return true;
        }

        public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
            return null;
        }

        public PermissionAttachment addAttachment(Plugin plugin) {
            return null;
        }

        public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
            return null;
        }

        public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
            return null;
        }

        public void removeAttachment(PermissionAttachment attachment) {
        }

        public void recalculatePermissions() {
        }

        public Set<PermissionAttachmentInfo> getEffectivePermissions() {
            return Collections.emptySet();
        }

        public boolean isOp() {
            return true;
        }

        public void setOp(boolean value) {
        }
    }
}

