/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bukkit;

import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.bukkit.Bridge;
import de.themoep.connectorplugin.bukkit.commands.ConnectorCommand;
import de.themoep.connectorplugin.bukkit.connector.BukkitConnector;
import de.themoep.connectorplugin.bukkit.connector.MqttConnector;
import de.themoep.connectorplugin.bukkit.connector.PluginMessageConnector;
import de.themoep.connectorplugin.bukkit.connector.RedisConnector;
import de.themoep.connectorplugin.connector.ConnectingPlugin;
import de.themoep.connectorplugin.connector.MessageTarget;
import java.io.File;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BukkitConnectorPlugin
extends JavaPlugin
implements ConnectorPlugin,
Listener {
    private BukkitConnector connector;
    private Bridge bridge;
    private boolean debug = true;
    private String group;
    private String serverName;

    public void onEnable() {
        String messengerType;
        this.saveDefaultConfig();
        this.reloadConfig();
        this.debug = this.getConfig().getBoolean("debug");
        this.group = this.getConfig().getString("group", "global");
        this.serverName = this.getConfig().getString("server-name", "changeme");
        if ("changeme".equals(this.serverName)) {
            this.serverName = new File(".").getAbsoluteFile().getParentFile().getName();
            this.getLogger().log(Level.WARNING, "Server name is not configured! Please set it in your plugin config! Using the name of the server directory instead: " + this.serverName);
        }
        switch (messengerType = this.getConfig().getString("messenger-type", "plugin_messages").toLowerCase(Locale.ROOT)) {
            default: {
                this.getLogger().log(Level.WARNING, "Messenger type '" + messengerType + "' is not supported, falling back to plugin messages!");
            }
            case "plugin_messages": {
                this.connector = new PluginMessageConnector(this);
                break;
            }
            case "redis": {
                this.connector = new RedisConnector(this);
                break;
            }
            case "mqtt": {
                this.connector = new MqttConnector(this);
            }
        }
        this.getCommand("connectorplugin").setExecutor((CommandExecutor)new ConnectorCommand(this));
        this.bridge = new Bridge(this);
    }

    public void onDisable() {
        this.connector.close();
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin() instanceof ConnectingPlugin) {
            this.connector.unregisterHandlers((ConnectingPlugin)event.getPlugin());
        }
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    @Override
    public BukkitConnector getConnector() {
        return this.connector;
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, runnable);
    }

    @Override
    public MessageTarget.Type getSourceType() {
        return MessageTarget.Type.SERVER;
    }

    @Override
    public void logDebug(String message, Throwable ... throwables) {
        if (this.debug) {
            this.getLogger().log(Level.INFO, "[DEBUG] " + message, throwables.length > 0 ? throwables[0] : null);
        }
    }

    @Override
    public void logWarning(String message, Throwable ... throwables) {
        this.getLogger().log(Level.WARNING, message, throwables.length > 0 ? throwables[0] : null);
    }

    @Override
    public void logError(String message, Throwable ... throwables) {
        this.getLogger().log(Level.SEVERE, message, throwables.length > 0 ? throwables[0] : null);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }
}

