/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bukkit.commands;

import de.themoep.connectorplugin.bukkit.commands.ConnectorCommand;
import de.themoep.connectorplugin.bukkit.commands.SubCommand;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ProxyPlayerCommand
extends SubCommand {
    public ProxyPlayerCommand(ConnectorCommand parent) {
        super(parent.getPlugin(), "proxyplayercommand <playername> <command...>", parent.getPermission() + ".proxyplayercommand", "proxyplayer", "player", "ppc");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 2) {
            return false;
        }
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage("No player with the name " + args[0] + " is online on this server!");
            return true;
        }
        String commandString = Arrays.stream(args).skip(1L).collect(Collectors.joining(" "));
        sender.sendMessage(ChatColor.GRAY + "Executing '" + commandString + "' on the proxy for player '" + player.getName() + "'");
        this.plugin.getBridge().runProxyPlayerCommand(player, commandString).thenAccept(success -> sender.sendMessage(success != false ? "Successfully executed command!" : "Error while executing the command."));
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }
}

