/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bukkit.commands;

import de.themoep.connectorplugin.bukkit.BukkitConnectorPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public abstract class SubCommand
implements TabExecutor {
    protected final BukkitConnectorPlugin plugin;
    private final String name;
    private final String usage;
    private final String[] aliases;
    private final String permission;
    private Map<String, SubCommand> subCommands = new LinkedHashMap<String, SubCommand>();
    private Map<String, SubCommand> subCommandAliases = new LinkedHashMap<String, SubCommand>();

    public SubCommand(BukkitConnectorPlugin plugin, String usage, String permission, String ... aliases) {
        this.plugin = plugin;
        String[] usageParts = usage.split(" ", 2);
        this.name = usageParts[0];
        this.usage = usageParts.length > 1 ? usageParts[1] : "";
        this.permission = permission;
        this.aliases = aliases;
    }

    public void registerSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(Locale.ROOT), subCommand);
        for (String alias : subCommand.getAliases()) {
            this.subCommandAliases.put(alias.toLowerCase(Locale.ROOT), subCommand);
        }
    }

    public SubCommand getSubCommand(String name) {
        SubCommand subCommand = this.subCommands.get(name.toLowerCase(Locale.ROOT));
        if (subCommand == null) {
            return this.subCommandAliases.get(name.toLowerCase(Locale.ROOT));
        }
        return subCommand;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        SubCommand subCommand = this.getSubCommand(args[0]);
        if (subCommand != null && sender.hasPermission(subCommand.getPermission())) {
            if (subCommand.onCommand(sender, command, label + " " + args[0], Arrays.copyOfRange(args, 1, args.length))) {
                return true;
            }
            if (!subCommand.getUsage().isEmpty()) {
                sender.sendMessage("Usage: /" + label + " " + args[0] + " " + subCommand.getUsage());
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0 || args[0].isEmpty()) {
            return new ArrayList<String>(this.subCommands.keySet());
        }
        SubCommand subCommand = this.getSubCommand(args[0]);
        if (subCommand != null && sender.hasPermission(subCommand.getPermission())) {
            return subCommand.onTabComplete(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
        }
        ArrayList<String> completions = new ArrayList<String>();
        for (Map.Entry<String, SubCommand> e : this.subCommands.entrySet()) {
            if (!e.getKey().startsWith(args[0].toLowerCase(Locale.ROOT)) || !sender.hasPermission(e.getValue().getPermission())) continue;
            completions.add(e.getKey());
        }
        for (Map.Entry<String, SubCommand> e : this.subCommandAliases.entrySet()) {
            if (!e.getKey().startsWith(args[0].toLowerCase(Locale.ROOT)) || !sender.hasPermission(e.getValue().getPermission())) continue;
            completions.add(e.getKey());
        }
        return completions;
    }

    public String getName() {
        return this.name;
    }

    public String getUsage() {
        return this.usage;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getPermission() {
        return this.permission;
    }

    public BukkitConnectorPlugin getPlugin() {
        return this.plugin;
    }

    public Map<String, SubCommand> getSubCommands() {
        return this.subCommands;
    }
}

