/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bukkit.commands;

import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.bukkit.commands.ConnectorCommand;
import de.themoep.connectorplugin.bukkit.commands.SubCommand;
import java.util.List;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class TeleportCommand
extends SubCommand {
    public TeleportCommand(ConnectorCommand parent) {
        super(parent.getPlugin(), "teleport <player> <server> [<world> <x> <y> <z> [<yaw> <pitch>]]", parent.getPermission() + ".teleport", "tp", "send");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 2) {
            return false;
        }
        String playerName = args[0];
        String serverName = args[1];
        if (args.length == 2) {
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
            this.plugin.getBridge().sendToServer(playerName, serverName, consumerArray).thenAccept(success -> {
                if (success.booleanValue()) {
                    sender.sendMessage(ChatColor.GREEN + "Successfully connected " + playerName + " to " + serverName);
                } else {
                    sender.sendMessage(ChatColor.RED + "Error while sending " + playerName + " to " + serverName);
                }
            });
            return true;
        }
        if (args.length == 3) {
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
            this.plugin.getBridge().teleport(playerName, serverName, args[2], consumerArray).thenAccept(success -> {
                if (!success.booleanValue()) {
                    sender.sendMessage(ChatColor.RED + "Error while teleporting...");
                }
            });
            return true;
        }
        if (args.length < 6) {
            return false;
        }
        try {
            LocationInfo location = new LocationInfo(serverName, args[2], Double.parseDouble(args[3]), Double.parseDouble(args[4]), Double.parseDouble(args[5]), args.length > 6 ? Float.parseFloat(args[6]) : 0.0f, args.length > 7 ? Float.parseFloat(args[7]) : 0.0f);
            sender.sendMessage("Sending teleport request for " + playerName);
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
            this.plugin.getBridge().teleport(playerName, location, consumerArray).thenAccept(success -> {
                if (!success.booleanValue()) {
                    sender.sendMessage(ChatColor.RED + "Error while teleporting...");
                }
            });
            return true;
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(ChatColor.RED + "Error while parsing input! " + e.getMessage());
            return false;
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }
}

