/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bukkit.connector;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.themoep.connectorplugin.bukkit.BukkitConnectorPlugin;
import de.themoep.connectorplugin.bukkit.connector.BukkitConnector;
import de.themoep.connectorplugin.connector.Message;
import de.themoep.connectorplugin.connector.MessageTarget;
import de.themoep.connectorplugin.connector.VersionMismatchException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class PluginMessageConnector
extends BukkitConnector
implements PluginMessageListener,
Listener {
    private Deque<byte[]> queue = new ArrayDeque<byte[]>();

    public PluginMessageConnector(BukkitConnectorPlugin plugin) {
        super(plugin, true);
        plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)plugin, plugin.getMessageChannel());
        plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)plugin, plugin.getMessageChannel(), (PluginMessageListener)this);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] data) {
        if (!channel.equals(((BukkitConnectorPlugin)this.plugin).getMessageChannel())) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        String group = in.readUTF();
        if (!group.equals(((BukkitConnectorPlugin)this.plugin).getGroup()) && !group.isEmpty()) {
            return;
        }
        String target = in.readUTF();
        if (target.startsWith("server:") && !target.equalsIgnoreCase("server:" + ((BukkitConnectorPlugin)this.plugin).getServerName())) {
            return;
        }
        if (!target.isEmpty() && !player.getName().equals(target) && (player = this.getReceiver(target)) == null) {
            ((BukkitConnectorPlugin)this.plugin).logError("Player " + player + " wasn't found online?", new Throwable[0]);
            return;
        }
        int messageLength = in.readInt();
        byte[] messageData = new byte[messageLength];
        in.readFully(messageData);
        try {
            this.handle(player, Message.fromByteArray(messageData));
        }
        catch (IllegalArgumentException e) {
            ((BukkitConnectorPlugin)this.plugin).logError("Invalid message target! " + e.getMessage(), new Throwable[0]);
        }
        catch (VersionMismatchException e) {
            ((BukkitConnectorPlugin)this.plugin).getLogger().log(Level.WARNING, e.getMessage() + ". Ignoring message!");
        }
    }

    @Override
    public void sendDataImplementation(String targetData, Message message) {
        byte[] messageData = message.writeToByteArray(this.plugin);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(((BukkitConnectorPlugin)this.plugin).getGroup());
        out.writeUTF(targetData);
        out.writeInt(messageData.length);
        out.write(messageData);
        byte[] dataToSend = out.toByteArray();
        Player player = null;
        if (!targetData.startsWith("server:")) {
            player = ((BukkitConnectorPlugin)this.plugin).getServer().getPlayer(targetData);
        }
        if (player != null) {
            player.sendPluginMessage((Plugin)this.plugin, ((BukkitConnectorPlugin)this.plugin).getMessageChannel(), dataToSend);
        } else if (message.getTarget() != MessageTarget.PROXY) {
            if (((BukkitConnectorPlugin)this.plugin).getServer().getOnlinePlayers().isEmpty()) {
                this.queue.add(dataToSend);
            } else {
                ((Player)((BukkitConnectorPlugin)this.plugin).getServer().getOnlinePlayers().iterator().next()).sendPluginMessage((Plugin)this.plugin, ((BukkitConnectorPlugin)this.plugin).getMessageChannel(), dataToSend);
            }
        } else {
            ((BukkitConnectorPlugin)this.plugin).logError("Could not send data to " + (Object)((Object)message.getTarget()) + " as player wasn't specified!", new Throwable[0]);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        while (!this.queue.isEmpty()) {
            event.getPlayer().sendPluginMessage((Plugin)this.plugin, ((BukkitConnectorPlugin)this.plugin).getMessageChannel(), this.queue.remove());
        }
    }
}

