/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bungee;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.themoep.connectorplugin.BridgeCommon;
import de.themoep.connectorplugin.BridgedCommand;
import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.ResponseHandler;
import de.themoep.connectorplugin.bungee.BungeeConnectorPlugin;
import de.themoep.connectorplugin.connector.ConnectingPlugin;
import de.themoep.connectorplugin.connector.MessageTarget;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.TabExecutor;

public class Bridge
extends BridgeCommon<BungeeConnectorPlugin> {
    private Table<String, String, BridgedCommand<?, CommandSender>> commands = HashBasedTable.create();

    public Bridge(BungeeConnectorPlugin plugin) {
        super(plugin);
        plugin.getConnector().registerHandler(plugin, "started", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            for (BridgedCommand command : this.commands.values()) {
                this.registerServerCommand(senderServer, command);
            }
        });
        plugin.getConnector().registerHandler(plugin, "send_to_server", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            String targetServer = in.readUTF();
            ProxiedPlayer player = plugin.getProxy().getPlayer(playerName);
            if (player == null) {
                plugin.logDebug("Could not find player " + playerName + " on this proxy to send to server " + targetServer, new Throwable[0]);
                this.sendResponse(senderServer, id, false, "Could not find player " + playerName + " on this proxy to send to server " + targetServer);
                return;
            }
            ServerInfo server = plugin.getProxy().getServerInfo(targetServer);
            if (server == null) {
                plugin.logDebug("Could not find server " + targetServer + " on this proxy to send player " + playerName + " to", new Throwable[0]);
                this.sendResponse(senderServer, id, false, "Could not find server " + targetServer + " on this proxy to send player " + playerName + " to");
                return;
            }
            if (!player.getServer().getInfo().equals(server)) {
                plugin.logDebug("Sending '" + playerName + "' to server '" + targetServer + "'. Triggered from " + senderServer, new Throwable[0]);
                player.connect(server, (success, ex) -> {
                    this.sendResponse(senderServer, id, (boolean)success, new String[0]);
                    if (ex != null) {
                        this.sendResponseMessage(senderServer, id, ex.getMessage());
                    }
                });
            } else {
                plugin.logDebug("Player '" + playerName + "' is already on server '" + targetServer + "'! Triggered from " + senderServer, new Throwable[0]);
                this.sendResponse(senderServer, id, true, playerName + " is already connected to server " + targetServer);
            }
        });
        plugin.getConnector().registerHandler(plugin, "teleport", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            LocationInfo targetLocation = LocationInfo.read(in);
            this.teleport(playerName, targetLocation, messages -> this.sendResponseMessage(senderServer, id, (String)messages)).thenAccept(success -> this.sendResponse(senderServer, id, (boolean)success, new String[0]));
        });
        plugin.getConnector().registerHandler(plugin, "teleport_to_world", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            String targetServer = in.readUTF();
            String targetWorld = in.readUTF();
            this.teleport(playerName, targetServer, targetWorld, messages -> this.sendResponseMessage(senderServer, id, (String)messages)).thenAccept(success -> this.sendResponse(senderServer, id, (boolean)success, new String[0]));
        });
        plugin.getConnector().registerHandler(plugin, "teleport_to_player", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            String targetName = in.readUTF();
            this.teleport(playerName, targetName, messages -> this.sendResponseMessage(senderServer, id, (String)messages)).thenAccept(success -> this.sendResponse(senderServer, id, (boolean)success, new String[0]));
        });
        plugin.getConnector().registerHandler(plugin, "player_command", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String serverName = in.readUTF();
            long id = in.readLong();
            String playerName = in.readUTF();
            UUID playerId = new UUID(in.readLong(), in.readLong());
            String command = in.readUTF();
            ProxiedPlayer player = plugin.getProxy().getPlayer(playerId);
            if (player == null) {
                player = plugin.getProxy().getPlayer(playerName);
            }
            if (player == null) {
                plugin.logDebug("Could not find player " + playerName + "/" + playerId + " on this proxy to execute command " + command, new Throwable[0]);
                this.sendResponse(serverName, id, false, "Could not find player " + playerName + "/" + playerId + " on this proxy to execute command " + command);
                return;
            }
            plugin.logDebug("Command '" + command + "' for player '" + playerName + "' triggered from " + serverName, new Throwable[0]);
            boolean success = plugin.getProxy().getPluginManager().dispatchCommand((CommandSender)player, command);
            this.sendResponse(serverName, id, player, success, new String[0]);
        });
        plugin.getConnector().registerHandler(plugin, "console_command", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String senderServer = in.readUTF();
            long id = in.readLong();
            String command = in.readUTF();
            plugin.logDebug("Console command '" + command + "' triggered from " + senderServer, new Throwable[0]);
            boolean success = plugin.getProxy().getPluginManager().dispatchCommand((CommandSender)new BridgedSender(senderServer, id), command);
            this.sendResponse(senderServer, id, success, new String[0]);
        });
        plugin.getConnector().registerHandler(plugin, "execute_command", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String serverName = in.readUTF();
            if (!serverName.equals(plugin.getServerName())) {
                return;
            }
            String senderName = in.readUTF();
            String pluginName = in.readUTF();
            String commandName = in.readUTF();
            Object sender = senderName.isEmpty() ? plugin.getProxy().getConsole() : plugin.getProxy().getPlayer(senderName);
            if (sender == null) {
                plugin.logDebug("Could not find player " + senderName + " for execution of command " + commandName + " for plugin " + pluginName, new Throwable[0]);
                return;
            }
            BridgedCommand command = (BridgedCommand)this.commands.get((Object)pluginName.toLowerCase(Locale.ROOT), (Object)commandName.toLowerCase(Locale.ROOT));
            if (command == null) {
                plugin.logDebug("Could not find executor for command " + commandName + " for plugin " + pluginName, new Throwable[0]);
                return;
            }
            String commandLabel = in.readUTF();
            int argsCount = in.readInt();
            String[] args = new String[argsCount];
            for (int i = 0; i < argsCount; ++i) {
                args[i] = in.readUTF();
            }
            LocationInfo location = null;
            if (sender instanceof ProxiedPlayer) {
                location = LocationInfo.read(in);
            }
            try {
                if (!command.onCommand(sender, location, commandLabel, args) && command.getUsage().length() > 0) {
                    for (String line : command.getUsage().replace("<command>", commandLabel).split("\n")) {
                        sender.sendMessage(line);
                    }
                }
            }
            catch (Throwable ex) {
                plugin.logError("Unhandled exception executing bridged command '" + commandLabel + "' from plugin " + command.getPlugin().getName(), ex);
            }
        });
        plugin.getConnector().registerHandler(plugin, "response", (receiver, data) -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            String serverName = in.readUTF();
            if (!serverName.equals(plugin.getServerName())) {
                return;
            }
            long id = in.readLong();
            boolean isCompletion = in.readBoolean();
            if (isCompletion) {
                this.handleResponse(id, in);
            } else {
                String message = in.readUTF();
                Consumer[] consumer = (Consumer[])this.consumers.getIfPresent((Object)id);
                if (consumer != null) {
                    for (Consumer stringConsumer : consumer) {
                        stringConsumer.accept(message);
                    }
                }
            }
        });
    }

    private void sendResponse(String server, long id, ProxiedPlayer player, boolean success, String ... messages) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(server);
        out.writeLong(id);
        out.writeBoolean(true);
        out.writeBoolean(success);
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "response", MessageTarget.SERVER, player, out.toByteArray());
        if (messages.length > 0) {
            this.sendResponseMessage(server, id, messages);
        }
    }

    private void sendResponse(String server, long id, boolean success, String ... messages) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(server);
        out.writeLong(id);
        out.writeBoolean(true);
        out.writeBoolean(success);
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "response", server.startsWith("proxy:") ? MessageTarget.OTHER_PROXIES : MessageTarget.ALL_QUEUE, out.toByteArray());
        if (messages.length > 0) {
            this.sendResponseMessage(server, id, messages);
        }
    }

    private void sendResponseMessage(String server, long id, String ... messages) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(server);
        out.writeLong(id);
        out.writeBoolean(false);
        out.writeUTF(String.join((CharSequence)"\n", messages));
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "response", server.startsWith("proxy:") ? MessageTarget.OTHER_PROXIES : MessageTarget.ALL_QUEUE, out.toByteArray());
    }

    public CompletableFuture<Boolean> teleport(String playerName, LocationInfo location, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ProxiedPlayer player = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(playerName);
        if (player == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find player " + playerName + " on this proxy to send to teleport to " + location, new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find player " + playerName + " on this proxy to teleport to " + location);
            }
            return future;
        }
        ServerInfo server = ((BungeeConnectorPlugin)this.plugin).getProxy().getServerInfo(location.getServer());
        if (server == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find server " + location.getServer() + " on this proxy to teleport player " + player.getName() + " to", new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find server " + location.getServer() + " on this proxy to teleport player " + player.getName() + " to");
            }
            return future;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getName());
        location.write(out);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "teleport", MessageTarget.SERVER, server.getName(), out.toByteArray());
        this.sendToServerIfNecessary(player, server, future, consumer);
        return future;
    }

    public CompletableFuture<Boolean> teleport(String playerName, String serverName, String worldName, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ProxiedPlayer player = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(playerName);
        if (player == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find player " + playerName + " on this proxy to send to teleport to " + serverName + "/" + worldName, new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find player " + playerName + " on this proxy to teleport to " + serverName + "/" + worldName);
            }
            return future;
        }
        ServerInfo server = ((BungeeConnectorPlugin)this.plugin).getProxy().getServerInfo(serverName);
        if (server == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find server " + serverName + " on this proxy to teleport player " + player.getName() + " to", new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find server " + serverName + " on this proxy to teleport player " + player.getName() + " to");
            }
            return future;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getName());
        out.writeUTF(serverName);
        out.writeUTF(worldName);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "teleport_to_world", MessageTarget.SERVER, server.getName(), out.toByteArray());
        this.sendToServerIfNecessary(player, server, future, consumer);
        return future;
    }

    public CompletableFuture<Boolean> teleport(String playerName, String targetName, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ProxiedPlayer player = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(playerName);
        if (player == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find player " + playerName + " on this proxy to send to teleport to " + targetName, new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find player " + playerName + " on this proxy to teleport to " + targetName);
            }
            return future;
        }
        ProxiedPlayer target = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(targetName);
        if (target == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Could not find target player " + targetName + " on this proxy to teleport " + player.getName() + " to", new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept("Could not find target player " + targetName + " on this proxy to teleport " + player.getName() + " to");
            }
            return future;
        }
        if (target.getServer() == null) {
            ((BungeeConnectorPlugin)this.plugin).logDebug(target.getName() + " is not currently connected to any server.", new Throwable[0]);
            future.complete(false);
            for (Consumer<String> c : consumer) {
                c.accept(target.getName() + " is not currently connected to any server.");
            }
            return future;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getName());
        out.writeUTF(target.getName());
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        this.consumers.put((Object)id, consumer);
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "teleport_to_player", MessageTarget.ALL_QUEUE, out.toByteArray());
        this.sendToServerIfNecessary(player, target.getServer().getInfo(), future, consumer);
        return future;
    }

    private void sendToServerIfNecessary(ProxiedPlayer player, ServerInfo server, CompletableFuture<Boolean> future, Consumer<String> ... consumer) {
        if (!player.getServer().getInfo().equals(server) && ((BungeeConnectorPlugin)this.plugin).getConnector().requiresPlayer() && server.getPlayers().isEmpty()) {
            ((BungeeConnectorPlugin)this.plugin).logDebug("Sending '" + player.getName() + "' to server '" + server.getName() + "'", new Throwable[0]);
            player.connect(server, (success, ex) -> {
                if (!success.booleanValue()) {
                    future.complete(false);
                    if (ex != null) {
                        for (Consumer c : consumer) {
                            c.accept(ex.getMessage());
                        }
                    }
                }
            });
        }
    }

    public CompletableFuture<LocationInfo> getLocation(ProxiedPlayer player) {
        CompletableFuture<LocationInfo> future = new CompletableFuture<LocationInfo>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getName());
        this.responses.put((Object)id, (Object)new ResponseHandler.Location(future));
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "get_location", MessageTarget.SERVER, player, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> runServerPlayerCommand(ProxiedPlayer player, String command) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(player.getName());
        out.writeLong(player.getUniqueId().getMostSignificantBits());
        out.writeLong(player.getUniqueId().getLeastSignificantBits());
        out.writeUTF(command);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "player_command", MessageTarget.SERVER, player, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> runServerConsoleCommand(String server, String command, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        out.writeUTF(server);
        out.writeLong(id);
        out.writeUTF(command);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        if (consumer != null && consumer.length > 0) {
            this.consumers.put((Object)id, consumer);
        }
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "console_command", MessageTarget.ALL_QUEUE, out.toByteArray());
        return future;
    }

    public CompletableFuture<Boolean> runProxyConsoleCommand(String command, Consumer<String> ... consumer) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        long id = RANDOM.nextLong();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        out.writeLong(id);
        out.writeUTF(command);
        this.responses.put((Object)id, (Object)new ResponseHandler.Boolean(future));
        if (consumer != null && consumer.length > 0) {
            this.consumers.put((Object)id, consumer);
        }
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "console_command", MessageTarget.OTHER_PROXIES, out.toByteArray());
        return future;
    }

    public void registerServerCommand(String server, BridgedCommand<?, CommandSender> command) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        this.write(out, command);
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData((ConnectingPlugin)this.plugin, "register_command", MessageTarget.SERVER, server, out.toByteArray());
    }

    public void registerServerCommand(BridgedCommand<? extends Plugin, CommandSender> command) {
        this.commands.put((Object)((ConnectingPlugin)command.getPlugin()).getName().toLowerCase(Locale.ROOT), (Object)command.getName().toLowerCase(Locale.ROOT), command);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getServerName());
        this.write(out, command);
        ((BungeeConnectorPlugin)this.plugin).getConnector().sendData(this.plugin, "register_command", MessageTarget.ALL_QUEUE, out.toByteArray());
        ((BungeeConnectorPlugin)this.plugin).getProxy().getPluginManager().registerCommand(command.getPlugin(), (Command)new ForwardingCommand(command.getName(), command.getPermission(), command));
        for (String alias : command.getAliases()) {
            ((BungeeConnectorPlugin)this.plugin).getProxy().getPluginManager().registerCommand(command.getPlugin(), (Command)new ForwardingCommand(alias, command.getPermission(), command));
        }
    }

    private void write(ByteArrayDataOutput out, BridgedCommand<?, CommandSender> command) {
        out.writeUTF(command.getPlugin().getName());
        out.writeUTF(command.getName());
        out.writeUTF(command.getDescription() != null ? command.getDescription() : "");
        out.writeUTF(command.getUsage() != null ? command.getUsage() : "");
        out.writeUTF(command.getPermission() != null ? command.getPermission() : "");
        if (command.getPermissionMessage() != null) {
            out.writeBoolean(true);
            out.writeUTF(command.getPermissionMessage());
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(command.getAliases().length);
        for (String alias : command.getAliases()) {
            out.writeUTF(alias);
        }
    }

    private class ForwardingCommand
    extends Command
    implements TabExecutor {
        private final BridgedCommand<? extends Plugin, CommandSender> command;

        public ForwardingCommand(String name, String permission, BridgedCommand<? extends Plugin, CommandSender> command) {
            super(name, permission, new String[0]);
            this.command = command;
        }

        public void execute(CommandSender sender, String[] args) {
            if (sender instanceof ProxiedPlayer) {
                ((ProxiedPlayer)sender).chat("/" + this.getName() + " " + String.join((CharSequence)" ", args));
            } else {
                this.command.onCommand(sender, null, this.getName(), args);
            }
        }

        public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
            if (this.command instanceof TabExecutor && sender.hasPermission(this.command.getPermission() + ".tabcomplete." + this.getName())) {
                return ((TabExecutor)this.command).onTabComplete(sender, args);
            }
            return Collections.emptySet();
        }
    }

    private class BridgedSender
    implements CommandSender {
        private final String serverName;
        private final long id;

        public BridgedSender(String serverName, long id) {
            this.serverName = serverName;
            this.id = id;
        }

        public String getName() {
            return this.serverName + "BridgedSender";
        }

        public void sendMessage(String message) {
            this.sendMessages(message);
        }

        public void sendMessages(String ... messages) {
            Bridge.this.sendResponseMessage(this.serverName, this.id, messages);
        }

        public void sendMessage(BaseComponent ... message) {
            this.sendMessage(TextComponent.toLegacyText((BaseComponent[])message));
        }

        public void sendMessage(BaseComponent message) {
            this.sendMessage(TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{message}));
        }

        public Collection<String> getGroups() {
            return null;
        }

        public void addGroups(String ... groups) {
        }

        public void removeGroups(String ... groups) {
        }

        public boolean hasPermission(String permission) {
            return true;
        }

        public void setPermission(String permission, boolean value) {
        }

        public Collection<String> getPermissions() {
            return Collections.emptySet();
        }
    }
}

