/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bungee;

import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.bungee.Bridge;
import de.themoep.connectorplugin.bungee.commands.ConnectorCommand;
import de.themoep.connectorplugin.bungee.connector.BungeeConnector;
import de.themoep.connectorplugin.bungee.connector.MqttConnector;
import de.themoep.connectorplugin.bungee.connector.PluginMessageConnector;
import de.themoep.connectorplugin.bungee.connector.RedisConnector;
import de.themoep.connectorplugin.bungee.plugin.BungeePlugin;
import de.themoep.connectorplugin.connector.MessageTarget;
import java.util.Locale;
import java.util.logging.Level;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

public final class BungeeConnectorPlugin
extends BungeePlugin
implements ConnectorPlugin {
    private BungeeConnector connector;
    private Bridge bridge;
    private boolean debug = true;

    public void onEnable() {
        String messengerType;
        this.debug = this.getConfig().getBoolean("debug");
        switch (messengerType = this.getConfig().getString("messenger-type", "plugin_messages").toLowerCase(Locale.ROOT)) {
            default: {
                this.getLogger().log(Level.WARNING, "Messenger type '" + messengerType + "' is not supported, falling back to plugin messages!");
            }
            case "plugin_messages": {
                this.connector = new PluginMessageConnector(this);
                break;
            }
            case "redis": {
                this.connector = new RedisConnector(this);
                break;
            }
            case "mqtt": {
                this.connector = new MqttConnector(this);
            }
        }
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ConnectorCommand(this));
        this.bridge = new Bridge(this);
    }

    public void onDisable() {
        this.connector.close();
    }

    @Override
    public BungeeConnector getConnector() {
        return this.connector;
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.getProxy().getScheduler().runAsync((Plugin)this, runnable);
    }

    @Override
    public MessageTarget.Type getSourceType() {
        return MessageTarget.Type.PROXY;
    }

    @Override
    public void logDebug(String message, Throwable ... throwables) {
        if (this.debug) {
            this.getLogger().log(Level.INFO, "[DEBUG] " + message, throwables.length > 0 ? throwables[0] : null);
        }
    }

    @Override
    public void logWarning(String message, Throwable ... throwables) {
        this.getLogger().log(Level.WARNING, message, throwables.length > 0 ? throwables[0] : null);
    }

    @Override
    public void logError(String message, Throwable ... throwables) {
        this.getLogger().log(Level.SEVERE, message, throwables.length > 0 ? throwables[0] : null);
    }

    @Override
    public String getServerName() {
        return "proxy:" + this.getProxy().getConfig().getUuid();
    }

    @Override
    public String getGroup() {
        return "";
    }

    @Override
    public String getName() {
        return this.getDescription().getName();
    }
}

