/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bungee.commands;

import de.themoep.connectorplugin.bungee.BungeeConnectorPlugin;
import de.themoep.connectorplugin.bungee.plugin.PluginCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.md_5.bungee.api.CommandSender;

public class SubCommand
extends PluginCommand<BungeeConnectorPlugin> {
    private Map<String, SubCommand> subCommands = new LinkedHashMap<String, SubCommand>();
    private Map<String, SubCommand> subCommandAliases = new LinkedHashMap<String, SubCommand>();

    public SubCommand(BungeeConnectorPlugin plugin, String name) {
        super(plugin, name);
    }

    public SubCommand(BungeeConnectorPlugin plugin, String usage, String permission, String ... aliases) {
        super(plugin, usage.split(" ", 2)[0], permission, null, null, "/" + usage, aliases);
    }

    public void registerSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(Locale.ROOT), subCommand);
        for (String alias : subCommand.getAliases()) {
            this.subCommandAliases.put(alias.toLowerCase(Locale.ROOT), subCommand);
        }
    }

    public SubCommand getSubCommand(String name) {
        SubCommand subCommand = this.subCommands.get(name.toLowerCase(Locale.ROOT));
        if (subCommand == null) {
            return this.subCommandAliases.get(name.toLowerCase(Locale.ROOT));
        }
        return subCommand;
    }

    @Override
    protected boolean run(CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        SubCommand subCommand = this.getSubCommand(args[0]);
        if (subCommand != null) {
            subCommand.execute(sender, Arrays.copyOfRange(args, 1, args.length));
            return true;
        }
        return false;
    }

    @Override
    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptySet();
        }
        if (args.length == 0 || args[0].isEmpty()) {
            return new ArrayList<String>(this.subCommands.keySet());
        }
        SubCommand subCommand = this.getSubCommand(args[0]);
        if (subCommand != null && sender.hasPermission(subCommand.getPermission())) {
            return subCommand.onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
        }
        ArrayList<String> completions = new ArrayList<String>();
        for (Map.Entry<String, SubCommand> e : this.subCommands.entrySet()) {
            if (!e.getKey().startsWith(args[0].toLowerCase(Locale.ROOT)) || !sender.hasPermission(e.getValue().getPermission())) continue;
            completions.add(e.getKey());
        }
        for (Map.Entry<String, SubCommand> e : this.subCommandAliases.entrySet()) {
            if (!e.getKey().startsWith(args[0].toLowerCase(Locale.ROOT)) || !sender.hasPermission(e.getValue().getPermission())) continue;
            completions.add(e.getKey());
        }
        return completions;
    }

    public Map<String, SubCommand> getSubCommands() {
        return this.subCommands;
    }
}

