/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bungee.commands;

import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.bungee.BungeeConnectorPlugin;
import de.themoep.connectorplugin.bungee.commands.ConnectorCommand;
import de.themoep.connectorplugin.bungee.commands.SubCommand;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class TeleportCommand
extends SubCommand {
    public TeleportCommand(ConnectorCommand parent) {
        super((BungeeConnectorPlugin)parent.getPlugin(), "teleport <player> <server> [<world> <x> <y> <z> [<yaw> <pitch>]]", parent.getPermission() + ".teleport", "tp", "send");
    }

    @Override
    public boolean run(CommandSender sender, String[] args) {
        if (args.length < 2) {
            return false;
        }
        ProxiedPlayer player = ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "No player with the name " + args[0] + " found!");
            return true;
        }
        ServerInfo server = ((BungeeConnectorPlugin)this.plugin).getProxy().getServerInfo(args[1]);
        if (server == null) {
            sender.sendMessage(ChatColor.RED + "No server with the name " + args[1] + " found!");
            return true;
        }
        if (args.length == 2) {
            player.connect(server, (success, ex) -> {
                if (success.booleanValue()) {
                    sender.sendMessage(ChatColor.GREEN + "Connected player " + player.getName() + " to server " + server.getName());
                } else {
                    sender.sendMessage(ChatColor.RED + "Error while connecting player " + player.getName() + " to server " + server.getName() + ": " + ex.getMessage());
                }
            });
            return true;
        }
        if (args.length == 3) {
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
            ((BungeeConnectorPlugin)this.plugin).getBridge().teleport(player.getName(), server.getName(), args[2], consumerArray).thenAccept(success -> {
                if (!success.booleanValue()) {
                    sender.sendMessage(ChatColor.RED + "Error while teleporting...");
                }
            });
            return true;
        }
        if (args.length < 6) {
            return false;
        }
        try {
            LocationInfo location = new LocationInfo(server.getName(), args[2], Double.parseDouble(args[3]), Double.parseDouble(args[4]), Double.parseDouble(args[5]), args.length > 6 ? Float.parseFloat(args[6]) : 0.0f, args.length > 7 ? Float.parseFloat(args[7]) : 0.0f);
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
            ((BungeeConnectorPlugin)this.plugin).getBridge().teleport(player.getName(), location, consumerArray).thenAccept(success -> {
                if (!success.booleanValue()) {
                    sender.sendMessage(ChatColor.RED + "Error while teleporting...");
                }
            });
            return true;
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(ChatColor.RED + "Error while parsing input! " + e.getMessage());
            return false;
        }
    }

    @Override
    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return Collections.emptySet();
        }
        if (args.length == 0) {
            return ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayers().stream().map(CommandSender::getName).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        if (args.length == 1) {
            return ((BungeeConnectorPlugin)this.plugin).getProxy().getPlayers().stream().map(CommandSender::getName).filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return ((BungeeConnectorPlugin)this.plugin).getProxy().getServers().values().stream().filter(s -> s.canAccess(sender)).map(ServerInfo::getName).filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
        }
        return Collections.emptySet();
    }
}

