/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.bungee.connector;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.themoep.connectorplugin.bungee.BungeeConnectorPlugin;
import de.themoep.connectorplugin.bungee.connector.BungeeConnector;
import de.themoep.connectorplugin.connector.Message;
import de.themoep.connectorplugin.connector.VersionMismatchException;
import java.util.logging.Level;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class PluginMessageConnector
extends BungeeConnector
implements Listener {
    public PluginMessageConnector(BungeeConnectorPlugin plugin) {
        super(plugin, true);
        plugin.getProxy().registerChannel(plugin.getMessageChannel());
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent event) {
        if (event.isCancelled() || !event.getTag().equals(((BungeeConnectorPlugin)this.plugin).getMessageChannel())) {
            return;
        }
        if (event.getSender() instanceof ProxiedPlayer) {
            event.setCancelled(true);
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])event.getData());
        String group = in.readUTF();
        String target = in.readUTF();
        int messageLength = in.readInt();
        byte[] messageData = new byte[messageLength];
        in.readFully(messageData);
        try {
            Message message = Message.fromByteArray(messageData);
            switch (message.getTarget()) {
                case ALL_WITH_PLAYERS: {
                    this.sendToAllWithPlayers(event.getData(), null);
                    break;
                }
                case ALL_QUEUE: {
                    this.sendToAllAndQueue(event.getData(), null);
                    break;
                }
                case OTHERS_WITH_PLAYERS: {
                    this.sendToAllWithPlayers(event.getData(), ((ProxiedPlayer)event.getSender()).getServer().getInfo());
                    break;
                }
                case OTHERS_QUEUE: {
                    this.sendToAllAndQueue(event.getData(), ((ProxiedPlayer)event.getSender()).getServer().getInfo());
                    break;
                }
                case PROXY: 
                case ALL_PROXIES: {
                    this.handle((ProxiedPlayer)event.getReceiver(), message);
                    break;
                }
                case SERVER: {
                    if (!target.isEmpty()) {
                        ServerInfo server = this.getTargetServer(target);
                        if (server != null) {
                            server.sendData(((BungeeConnectorPlugin)this.plugin).getMessageChannel(), event.getData(), true);
                            break;
                        }
                        ((BungeeConnectorPlugin)this.plugin).logError(target + " doesn't exist?", new Throwable[0]);
                        break;
                    }
                    ((BungeeConnectorPlugin)this.plugin).logError((Object)((Object)message.getTarget()) + " message target requires explicit target!", new Throwable[0]);
                    break;
                }
                default: {
                    ((BungeeConnectorPlugin)this.plugin).logError("Receiving " + (Object)((Object)message.getTarget()) + " is not supported!", new Throwable[0]);
                }
            }
        }
        catch (IllegalArgumentException e) {
            ((BungeeConnectorPlugin)this.plugin).logError("Invalid message target! " + e.getMessage(), new Throwable[0]);
        }
        catch (VersionMismatchException e) {
            ((BungeeConnectorPlugin)this.plugin).getLogger().log(Level.WARNING, e.getMessage() + ". Ignoring message!");
        }
    }

    private void sendToAllWithPlayers(byte[] data, ServerInfo excludedServer) {
        this.sendToAll(data, false, excludedServer);
    }

    private void sendToAllAndQueue(byte[] data, ServerInfo excludedServer) {
        this.sendToAll(data, true, excludedServer);
    }

    private void sendToAll(byte[] data, boolean queue, ServerInfo excludedServer) {
        for (ServerInfo server : ((BungeeConnectorPlugin)this.plugin).getProxy().getServers().values()) {
            if (excludedServer != null && excludedServer == server) continue;
            server.sendData(((BungeeConnectorPlugin)this.plugin).getMessageChannel(), data, queue);
        }
    }

    @Override
    public void sendDataImplementation(String targetData, Message message) {
        byte[] messageData = message.writeToByteArray(this.plugin);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(((BungeeConnectorPlugin)this.plugin).getGroup());
        out.writeInt(messageData.length);
        out.write(messageData);
        byte[] dataToSend = out.toByteArray();
        ServerInfo server = this.getTargetServer(targetData);
        switch (message.getTarget()) {
            case ALL_WITH_PLAYERS: {
                this.sendToAllWithPlayers(dataToSend, null);
                break;
            }
            case ALL_QUEUE: {
                this.sendToAllAndQueue(dataToSend, null);
                break;
            }
            case OTHERS_WITH_PLAYERS: {
                this.sendToAllWithPlayers(dataToSend, server);
                break;
            }
            case OTHERS_QUEUE: {
                this.sendToAllAndQueue(dataToSend, server);
                break;
            }
            case SERVER: {
                if (server != null) {
                    server.sendData(((BungeeConnectorPlugin)this.plugin).getMessageChannel(), dataToSend);
                    break;
                }
                throw new UnsupportedOperationException("Could not send data to " + (Object)((Object)message.getTarget()) + " as target server wasn't found from " + targetData + "!");
            }
            default: {
                throw new UnsupportedOperationException("Sending to " + (Object)((Object)message.getTarget()) + " is not supported!");
            }
        }
    }
}

