/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.connector;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.connector.ConnectingPlugin;
import de.themoep.connectorplugin.connector.Message;
import de.themoep.connectorplugin.connector.MessageTarget;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class Connector<P extends ConnectorPlugin, R> {
    protected final P plugin;
    public static final String SERVER_PREFIX = "server:";
    private final boolean requiresPlayer;
    private Table<String, String, BiConsumer<R, byte[]>> handlers = HashBasedTable.create();

    public Connector(P plugin, boolean requiresPlayer) {
        this.plugin = plugin;
        this.requiresPlayer = requiresPlayer;
    }

    protected void handle(R receiver, Message message) {
        if (message.getTarget().getType() != this.plugin.getSourceType()) {
            return;
        }
        switch (message.getTarget()) {
            case OTHERS_WITH_PLAYERS: 
            case OTHERS_QUEUE: 
            case OTHER_PROXIES: {
                if (!message.getSendingServer().equals(this.plugin.getServerName())) break;
                return;
            }
            case PROXY: {
                if (receiver != null) break;
                return;
            }
        }
        BiConsumer handler = (BiConsumer)this.handlers.get((Object)message.getSendingPlugin().toLowerCase(Locale.ROOT), (Object)message.getAction());
        if (handler != null) {
            handler.accept(receiver, message.getData());
        } else {
            this.plugin.logDebug("Plugin '" + message.getSendingPlugin() + " did not register an action '" + message.getAction() + "' but we received data with target '" + (Object)((Object)message.getTarget()) + "' by " + receiver, new Throwable[0]);
        }
    }

    public void sendData(ConnectingPlugin sender, String action, MessageTarget target, byte[] data) {
        this.sendData(sender, action, target, (String)null, data);
    }

    public void sendData(ConnectingPlugin sender, String action, MessageTarget target, R player, byte[] data) {
        this.sendDataInternal(sender, action, target, player, data);
    }

    public void sendData(ConnectingPlugin sender, String action, MessageTarget target, String server, byte[] data) {
        this.sendDataInternal(sender, action, target, server, data);
    }

    public void sendDataInternal(ConnectingPlugin sender, String action, MessageTarget target, Object targetData, byte[] data) {
        if (target.getSource() != null && target.getSource() != this.plugin.getSourceType()) {
            throw new UnsupportedOperationException("Cannot send message with target " + (Object)((Object)target) + " from " + (Object)((Object)this.plugin.getSourceType()));
        }
        this.sendDataImplementation(targetData, new Message(target, this.plugin.getServerName(), sender.getName(), action, data));
    }

    protected abstract void sendDataImplementation(Object var1, Message var2);

    protected abstract R getReceiver(String var1);

    public BiConsumer<R, byte[]> registerHandler(ConnectingPlugin plugin, String action, BiConsumer<R, byte[]> handler) {
        return (BiConsumer)this.handlers.put((Object)plugin.getName().toLowerCase(Locale.ROOT), (Object)action, handler);
    }

    public BiConsumer<R, byte[]> unregisterHandler(ConnectingPlugin plugin, String action) {
        return (BiConsumer)this.handlers.remove((Object)plugin.getName().toLowerCase(Locale.ROOT), (Object)action);
    }

    public Map<String, BiConsumer<R, byte[]>> unregisterHandlers(ConnectingPlugin plugin) {
        return (Map)this.handlers.rowMap().remove(plugin.getName().toLowerCase(Locale.ROOT));
    }

    public boolean requiresPlayer() {
        return this.requiresPlayer;
    }

    public void close() {
    }
}

