/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.connector;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.connector.MessageTarget;
import de.themoep.connectorplugin.connector.VersionMismatchException;

public class Message {
    private static final int VERSION = 2;
    private final MessageTarget target;
    private final String sendingServer;
    private final String sendingPlugin;
    private final String action;
    private final byte[] data;

    public Message(MessageTarget target, String sendingServer, String sendingPlugin, String action, byte[] data) {
        this.target = target;
        this.sendingServer = sendingServer;
        this.sendingPlugin = sendingPlugin;
        this.action = action;
        this.data = data;
    }

    public MessageTarget getTarget() {
        return this.target;
    }

    public String getSendingServer() {
        return this.sendingServer;
    }

    public String getSendingPlugin() {
        return this.sendingPlugin;
    }

    public String getAction() {
        return this.action;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] writeToByteArray(ConnectorPlugin plugin) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeInt(2);
        out.writeUTF(this.target.name());
        out.writeUTF(this.sendingServer);
        out.writeUTF(this.sendingPlugin);
        out.writeUTF(this.action);
        out.writeInt(this.data.length);
        out.write(this.data);
        return out.toByteArray();
    }

    public static Message fromByteArray(byte[] messageData) throws VersionMismatchException {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])messageData);
        int messageVersion = in.readInt();
        if (messageVersion != 2) {
            throw new VersionMismatchException(messageVersion, 2, "Received an unsupported version " + messageVersion + ", only supporting " + 2);
        }
        MessageTarget target = MessageTarget.valueOf(in.readUTF());
        String senderServer = in.readUTF();
        String senderPlugin = in.readUTF();
        String action = in.readUTF();
        int length = in.readInt();
        byte[] data = new byte[length];
        in.readFully(data);
        return new Message(target, senderServer, senderPlugin, action, data);
    }
}

