/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.connector;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.connector.Message;
import de.themoep.connectorplugin.connector.VersionMismatchException;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttClient;
import de.themoep.connectorplugin.lib.paho.mqttv5.client.MqttConnectionOptions;
import de.themoep.connectorplugin.lib.paho.mqttv5.common.MqttException;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;

public class MqttConnection {
    private final ConnectorPlugin plugin;
    private MqttClient client;

    public MqttConnection(ConnectorPlugin plugin, String brokerURI, String clientID, String username, String password, int keepAlive, BiConsumer<String, Message> onMessage) {
        this.plugin = plugin;
        MqttConnectionOptions conOpts = new MqttConnectionOptions();
        conOpts.setCleanStart(true);
        if (clientID == null || clientID.isEmpty()) {
            clientID = plugin.getName() + "-" + plugin.getServerName() + "-" + Thread.currentThread().getId();
        }
        if (username != null) {
            conOpts.setUserName(username);
        }
        if (password != null) {
            conOpts.setPassword(password.getBytes(StandardCharsets.UTF_8));
        }
        conOpts.setKeepAliveInterval(keepAlive);
        conOpts.setAutomaticReconnect(true);
        try {
            this.client = new MqttClient(brokerURI, clientID);
            this.client.connect(conOpts);
            this.client.subscribe(plugin.getMessageChannel(), 1, (topic, message) -> {
                if (!topic.equals(plugin.getMessageChannel())) {
                    return;
                }
                if (message.getPayload().length == 0) {
                    plugin.logWarning("Received a message with 0 bytes on " + topic + " MQTT topic? ", new Throwable[0]);
                    return;
                }
                ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message.getPayload());
                String group = in.readUTF();
                if (!(group.equals(plugin.getGroup()) || group.isEmpty() || plugin.getGroup().isEmpty())) {
                    return;
                }
                String target = in.readUTF();
                if (target.startsWith("server:") && !target.equalsIgnoreCase("server:" + plugin.getServerName())) {
                    return;
                }
                int messageLength = in.readInt();
                byte[] messageData = new byte[messageLength];
                in.readFully(messageData);
                try {
                    onMessage.accept(target, Message.fromByteArray(messageData));
                }
                catch (IllegalArgumentException e) {
                    plugin.logError("Error while decoding message on " + topic + " MQTT topic! ", e);
                }
                catch (VersionMismatchException e) {
                    plugin.logWarning(e.getMessage() + ". Ignoring message!", new Throwable[0]);
                }
            });
        }
        catch (MqttException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void sendMessage(String senderName, Message message) {
        byte[] messageData = message.writeToByteArray(this.plugin);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(this.plugin.getGroup());
        out.writeUTF(senderName != null ? senderName : "");
        out.writeInt(messageData.length);
        out.write(messageData);
        byte[] dataToSend = out.toByteArray();
        this.plugin.runAsync(() -> {
            try {
                this.client.publish(this.plugin.getMessageChannel(), dataToSend, 1, false);
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        });
    }

    public void close() {
        try {
            this.client.disconnect();
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }
}

