/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.connector;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.themoep.connectorplugin.ConnectorPlugin;
import de.themoep.connectorplugin.connector.Message;
import de.themoep.connectorplugin.connector.VersionMismatchException;
import de.themoep.connectorplugin.lib.lettuce.core.RedisClient;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.api.StatefulRedisConnection;
import de.themoep.connectorplugin.lib.lettuce.core.codec.ByteArrayCodec;
import de.themoep.connectorplugin.lib.lettuce.core.codec.RedisCodec;
import de.themoep.connectorplugin.lib.lettuce.core.codec.StringCodec;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.RedisPubSubListener;
import de.themoep.connectorplugin.lib.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.function.BiConsumer;

public class RedisConnection {
    private final ConnectorPlugin plugin;
    private final RedisClient client;
    private StatefulRedisConnection<String, byte[]> connection;

    public RedisConnection(final ConnectorPlugin plugin, String uriString, String host, int port, String password, long timeout, final BiConsumer<String, Message> onMessage) {
        this.plugin = plugin;
        RedisURI uri = new RedisURI();
        if (uriString != null && !uriString.isEmpty()) {
            uri = RedisURI.create(uriString);
        }
        if (host != null && !host.isEmpty()) {
            uri.setHost(host);
        }
        if (port > 0) {
            uri.setPort(port);
        }
        if (password != null && !password.isEmpty()) {
            uri.setPassword(password);
        }
        if (timeout > 0L) {
            uri.setTimeout(Duration.ofSeconds(timeout));
        }
        this.client = RedisClient.create(uri);
        StatefulRedisPubSubConnection<String, byte[]> connection = this.client.connectPubSub(new StringByteArrayCodec());
        connection.addListener(new RedisPubSubListener<String, byte[]>(){

            @Override
            public void message(String channel, byte[] data) {
                if (!channel.equals(plugin.getMessageChannel())) {
                    return;
                }
                if (data.length == 0) {
                    plugin.logWarning("Received a message with 0 bytes on " + channel + " redis channel? ", new Throwable[0]);
                    return;
                }
                ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
                String group = in.readUTF();
                if (!(group.equals(plugin.getGroup()) || group.isEmpty() || plugin.getGroup().isEmpty())) {
                    return;
                }
                String target = in.readUTF();
                if (target.startsWith("server:") && !target.equalsIgnoreCase("server:" + plugin.getServerName())) {
                    return;
                }
                int messageLength = in.readInt();
                byte[] messageData = new byte[messageLength];
                in.readFully(messageData);
                try {
                    onMessage.accept(target, Message.fromByteArray(messageData));
                }
                catch (IllegalArgumentException e) {
                    plugin.logError("Error while decoding message on " + channel + " redis channel! ", e);
                }
                catch (VersionMismatchException e) {
                    plugin.logWarning(e.getMessage() + ". Ignoring message!", new Throwable[0]);
                }
            }

            @Override
            public void message(String pattern, String channel, byte[] message) {
            }

            @Override
            public void subscribed(String channel, long count) {
            }

            @Override
            public void psubscribed(String pattern, long count) {
            }

            @Override
            public void unsubscribed(String channel, long count) {
            }

            @Override
            public void punsubscribed(String pattern, long count) {
            }
        });
        connection.async().subscribe(plugin.getMessageChannel());
    }

    public void sendMessage(String targetData, Message message) {
        if (this.connection == null || !this.connection.isOpen()) {
            this.connection = this.client.connect(new StringByteArrayCodec());
        }
        byte[] messageData = message.writeToByteArray(this.plugin);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(this.plugin.getGroup());
        out.writeUTF(targetData != null ? targetData : "");
        out.writeInt(messageData.length);
        out.write(messageData);
        byte[] dataToSend = out.toByteArray();
        this.connection.async().publish(this.plugin.getMessageChannel(), dataToSend);
    }

    public void close() {
        this.client.shutdown();
    }

    private class StringByteArrayCodec
    implements RedisCodec<String, byte[]> {
        private final StringCodec stringCodec = new StringCodec();
        private final ByteArrayCodec byteArrayCodec = new ByteArrayCodec();

        private StringByteArrayCodec() {
        }

        @Override
        public String decodeKey(ByteBuffer bytes) {
            return this.stringCodec.decodeKey(bytes);
        }

        @Override
        public byte[] decodeValue(ByteBuffer bytes) {
            return this.byteArrayCodec.decodeValue(bytes);
        }

        @Override
        public ByteBuffer encodeKey(String key) {
            return this.stringCodec.encodeKey(key);
        }

        @Override
        public ByteBuffer encodeValue(byte[] value) {
            return this.byteArrayCodec.encodeValue(value);
        }
    }
}

