/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.ClientOptions;
import de.themoep.connectorplugin.lib.lettuce.core.ConnectionBuilder;
import de.themoep.connectorplugin.lib.lettuce.core.ConnectionEvents;
import de.themoep.connectorplugin.lib.lettuce.core.ConnectionFuture;
import de.themoep.connectorplugin.lib.lettuce.core.ConnectionPoint;
import de.themoep.connectorplugin.lib.lettuce.core.ConnectionState;
import de.themoep.connectorplugin.lib.lettuce.core.DefaultConnectionFuture;
import de.themoep.connectorplugin.lib.lettuce.core.RedisChannelHandler;
import de.themoep.connectorplugin.lib.lettuce.core.RedisConnectionException;
import de.themoep.connectorplugin.lib.lettuce.core.RedisConnectionStateListener;
import de.themoep.connectorplugin.lib.lettuce.core.RedisHandshake;
import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.event.command.CommandListener;
import de.themoep.connectorplugin.lib.lettuce.core.event.connection.ConnectEvent;
import de.themoep.connectorplugin.lib.lettuce.core.event.connection.ConnectionCreatedEvent;
import de.themoep.connectorplugin.lib.lettuce.core.event.jfr.EventRecorder;
import de.themoep.connectorplugin.lib.lettuce.core.internal.AsyncCloseable;
import de.themoep.connectorplugin.lib.lettuce.core.internal.Exceptions;
import de.themoep.connectorplugin.lib.lettuce.core.internal.Futures;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceStrings;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.ConnectionWatchdog;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.RedisHandshakeHandler;
import de.themoep.connectorplugin.lib.lettuce.core.resource.ClientResources;
import de.themoep.connectorplugin.lib.lettuce.core.resource.DefaultClientResources;
import de.themoep.connectorplugin.lib.lettuce.core.resource.Transports;
import de.themoep.connectorplugin.lib.netty.bootstrap.Bootstrap;
import de.themoep.connectorplugin.lib.netty.buffer.ByteBufAllocator;
import de.themoep.connectorplugin.lib.netty.channel.Channel;
import de.themoep.connectorplugin.lib.netty.channel.ChannelFuture;
import de.themoep.connectorplugin.lib.netty.channel.ChannelInitializer;
import de.themoep.connectorplugin.lib.netty.channel.ChannelOption;
import de.themoep.connectorplugin.lib.netty.channel.ChannelPipeline;
import de.themoep.connectorplugin.lib.netty.channel.EventLoopGroup;
import de.themoep.connectorplugin.lib.netty.channel.group.ChannelGroup;
import de.themoep.connectorplugin.lib.netty.channel.group.DefaultChannelGroup;
import de.themoep.connectorplugin.lib.netty.util.concurrent.Future;
import de.themoep.connectorplugin.lib.netty.util.concurrent.GenericFutureListener;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import java.io.Closeable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractRedisClient {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractRedisClient.class);
    private static final int EVENTLOOP_ACQ_INACTIVE = 0;
    private static final int EVENTLOOP_ACQ_ACTIVE = 1;
    private final AtomicInteger eventLoopGroupCas = new AtomicInteger();
    protected final ConnectionEvents connectionEvents = new ConnectionEvents();
    protected final Set<Closeable> closeableResources = ConcurrentHashMap.newKeySet();
    protected final ChannelGroup channels;
    private final ClientResources clientResources;
    private final List<CommandListener> commandListeners = new ArrayList<CommandListener>();
    private final Map<Class<? extends EventLoopGroup>, EventLoopGroup> eventLoopGroups = new ConcurrentHashMap<Class<? extends EventLoopGroup>, EventLoopGroup>(2);
    private final boolean sharedResources;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private volatile ClientOptions clientOptions = ClientOptions.create();
    private volatile Duration defaultTimeout = RedisURI.DEFAULT_TIMEOUT_DURATION;

    protected AbstractRedisClient(ClientResources clientResources) {
        if (clientResources == null) {
            this.sharedResources = false;
            this.clientResources = DefaultClientResources.create();
        } else {
            this.sharedResources = true;
            this.clientResources = clientResources;
        }
        this.channels = new DefaultChannelGroup(this.clientResources.eventExecutorGroup().next());
    }

    protected int getChannelCount() {
        return this.channels.size();
    }

    public Duration getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout duration must not be null");
        LettuceAssert.isTrue(!timeout.isNegative(), "Timeout duration must be greater or equal to zero");
        this.defaultTimeout = timeout;
    }

    @Deprecated
    public void setDefaultTimeout(long timeout, TimeUnit unit) {
        this.setDefaultTimeout(Duration.ofNanos(unit.toNanos(timeout)));
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    protected void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull((Object)clientOptions, "ClientOptions must not be null");
        this.clientOptions = clientOptions;
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    protected int getResourceCount() {
        return this.closeableResources.size();
    }

    public void addListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull((Object)listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.addListener(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull((Object)listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.removeListener(listener);
    }

    public void addListener(CommandListener listener) {
        LettuceAssert.notNull((Object)listener, "CommandListener must not be null");
        this.commandListeners.add(listener);
    }

    public void removeListener(CommandListener listener) {
        LettuceAssert.notNull((Object)listener, "CommandListener must not be null");
        this.commandListeners.remove(listener);
    }

    protected List<CommandListener> getCommandListeners() {
        return this.commandListeners;
    }

    protected void connectionBuilder(Mono<SocketAddress> socketAddressSupplier, ConnectionBuilder connectionBuilder, RedisURI redisURI) {
        Bootstrap redisBootstrap = new Bootstrap();
        redisBootstrap.option(ChannelOption.ALLOCATOR, ByteBufAllocator.DEFAULT);
        connectionBuilder.bootstrap(redisBootstrap);
        connectionBuilder.apply(redisURI);
        connectionBuilder.configureBootstrap(!LettuceStrings.isEmpty(redisURI.getSocket()), this::getEventLoopGroup);
        connectionBuilder.channelGroup(this.channels).connectionEvents(this.connectionEvents);
        connectionBuilder.socketAddressSupplier(socketAddressSupplier);
    }

    protected void channelType(ConnectionBuilder connectionBuilder, ConnectionPoint connectionPoint) {
        LettuceAssert.notNull((Object)connectionPoint, "ConnectionPoint must not be null");
        boolean domainSocket = LettuceStrings.isNotEmpty(connectionPoint.getSocket());
        connectionBuilder.bootstrap().group(this.getEventLoopGroup(domainSocket ? Transports.NativeTransports.eventLoopGroupClass() : Transports.eventLoopGroupClass()));
        if (connectionPoint.getSocket() != null) {
            Transports.NativeTransports.assertDomainSocketAvailable();
            connectionBuilder.bootstrap().channel(Transports.NativeTransports.domainSocketChannelClass());
        } else {
            connectionBuilder.bootstrap().channel(Transports.socketChannelClass());
        }
    }

    private EventLoopGroup getEventLoopGroup(Class<? extends EventLoopGroup> eventLoopGroupClass) {
        while (!this.eventLoopGroupCas.compareAndSet(0, 1)) {
        }
        try {
            EventLoopGroup eventLoopGroup = this.eventLoopGroups.computeIfAbsent(eventLoopGroupClass, it -> this.clientResources.eventLoopGroupProvider().allocate(it));
            return eventLoopGroup;
        }
        finally {
            this.eventLoopGroupCas.set(0);
        }
    }

    protected <T> T getConnection(ConnectionFuture<T> connectionFuture) {
        try {
            return connectionFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RedisConnectionException.create(connectionFuture.getRemoteAddress(), (Throwable)e);
        }
        catch (Exception e) {
            throw RedisConnectionException.create(connectionFuture.getRemoteAddress(), Exceptions.unwrap(e));
        }
    }

    protected <T> T getConnection(CompletableFuture<T> connectionFuture) {
        try {
            return connectionFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RedisConnectionException.create(e);
        }
        catch (Exception e) {
            throw RedisConnectionException.create(Exceptions.unwrap(e));
        }
    }

    protected <K, V, T extends RedisChannelHandler<K, V>> ConnectionFuture<T> initializeChannelAsync(ConnectionBuilder connectionBuilder) {
        Mono<SocketAddress> socketAddressSupplier = connectionBuilder.socketAddress();
        if (this.clientResources.eventExecutorGroup().isShuttingDown()) {
            throw new IllegalStateException("Cannot connect, Event executor group is terminated.");
        }
        CompletableFuture<SocketAddress> socketAddressFuture = new CompletableFuture<SocketAddress>();
        CompletableFuture channelReadyFuture = new CompletableFuture();
        EventRecorder.getInstance().record(new ConnectionCreatedEvent(connectionBuilder.getRedisURI().toString(), connectionBuilder.endpoint().getId()));
        EventRecorder.RecordableEvent event = EventRecorder.getInstance().start(new ConnectEvent(connectionBuilder.getRedisURI().toString(), connectionBuilder.endpoint().getId()));
        channelReadyFuture.whenComplete((channel, throwable) -> event.record());
        socketAddressSupplier.doOnError(socketAddressFuture::completeExceptionally).doOnNext(socketAddressFuture::complete).subscribe(redisAddress -> {
            if (channelReadyFuture.isCancelled()) {
                return;
            }
            this.initializeChannelAsync0(connectionBuilder, channelReadyFuture, (SocketAddress)redisAddress);
        }, channelReadyFuture::completeExceptionally);
        return new DefaultConnectionFuture(socketAddressFuture, channelReadyFuture.thenApply(channel -> connectionBuilder.connection()));
    }

    private void initializeChannelAsync0(ConnectionBuilder connectionBuilder, CompletableFuture<Channel> channelReadyFuture, SocketAddress redisAddress) {
        logger.debug("Connecting to Redis at {}", (Object)redisAddress);
        Bootstrap redisBootstrap = connectionBuilder.bootstrap();
        ChannelInitializer<Channel> initializer = connectionBuilder.build(redisAddress);
        redisBootstrap.handler(initializer);
        this.clientResources.nettyCustomizer().afterBootstrapInitialized(redisBootstrap);
        ChannelFuture connectFuture = redisBootstrap.connect(redisAddress);
        channelReadyFuture.whenComplete((c, t) -> {
            if (t instanceof CancellationException) {
                connectFuture.cancel(true);
            }
        });
        connectFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (!future.isSuccess()) {
                logger.debug("Connecting to Redis at {}: {}", (Object)redisAddress, (Object)future.cause());
                connectionBuilder.endpoint().initialState();
                channelReadyFuture.completeExceptionally(future.cause());
                return;
            }
            RedisHandshakeHandler handshakeHandler = connectFuture.channel().pipeline().get(RedisHandshakeHandler.class);
            if (handshakeHandler == null) {
                channelReadyFuture.completeExceptionally(new IllegalStateException("RedisHandshakeHandler not registered"));
                return;
            }
            handshakeHandler.channelInitialized().whenComplete((success, throwable) -> {
                if (throwable == null) {
                    logger.debug("Connecting to Redis at {}: Success", (Object)redisAddress);
                    RedisChannelHandler<?, ?> connection = connectionBuilder.connection();
                    connection.registerCloseables(this.closeableResources, connection);
                    channelReadyFuture.complete(connectFuture.channel());
                    return;
                }
                logger.debug("Connecting to Redis at {}, initialization: {}", (Object)redisAddress, throwable);
                connectionBuilder.endpoint().initialState();
                Throwable failure = throwable instanceof RedisConnectionException ? throwable : (throwable instanceof TimeoutException ? new RedisConnectionException("Could not initialize channel within " + connectionBuilder.getTimeout(), (Throwable)throwable) : throwable);
                channelReadyFuture.completeExceptionally(failure);
            });
        }));
    }

    public void shutdown() {
        this.shutdown(0L, 2L, TimeUnit.SECONDS);
    }

    public void shutdown(Duration quietPeriod, Duration timeout) {
        this.shutdown(quietPeriod.toNanos(), timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public void shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        try {
            this.shutdownAsync(quietPeriod, timeout, timeUnit).get();
        }
        catch (Exception e) {
            throw Exceptions.bubble(e);
        }
    }

    public CompletableFuture<Void> shutdownAsync() {
        return this.shutdownAsync(0L, 2L, TimeUnit.SECONDS);
    }

    public CompletableFuture<Void> shutdownAsync(long quietPeriod, long timeout, TimeUnit timeUnit) {
        if (this.shutdown.compareAndSet(false, true)) {
            logger.debug("Initiate shutdown ({}, {}, {})", new Object[]{quietPeriod, timeout, timeUnit});
            return this.closeResources().thenCompose(value -> this.closeClientResources(quietPeriod, timeout, timeUnit));
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> closeResources() {
        ArrayList<CompletionStage<Void>> closeFutures = new ArrayList<CompletionStage<Void>>();
        while (!this.closeableResources.isEmpty()) {
            Closeable closeableResource = this.closeableResources.iterator().next();
            if (closeableResource instanceof AsyncCloseable) {
                closeFutures.add(((AsyncCloseable)((Object)closeableResource)).closeAsync());
            } else {
                try {
                    closeableResource.close();
                }
                catch (Exception e) {
                    logger.debug("Exception on Close: " + e.getMessage(), e);
                }
            }
            this.closeableResources.remove(closeableResource);
        }
        for (Channel c : this.channels) {
            ChannelPipeline pipeline = c.pipeline();
            ConnectionWatchdog commandHandler = pipeline.get(ConnectionWatchdog.class);
            if (commandHandler == null) continue;
            commandHandler.setListenOnChannelInactive(false);
        }
        try {
            closeFutures.add(Futures.toCompletionStage(this.channels.close()));
        }
        catch (Exception e) {
            logger.debug("Cannot close channels", e);
        }
        return Futures.allOf(closeFutures);
    }

    private CompletableFuture<Void> closeClientResources(long quietPeriod, long timeout, TimeUnit timeUnit) {
        ArrayList<CompletionStage<Boolean>> groupCloseFutures = new ArrayList<CompletionStage<Boolean>>();
        if (!this.sharedResources) {
            Future<Boolean> groupCloseFuture = this.clientResources.shutdown(quietPeriod, timeout, timeUnit);
            groupCloseFutures.add(Futures.toCompletionStage(groupCloseFuture));
        } else {
            for (EventLoopGroup eventExecutors : this.eventLoopGroups.values()) {
                Future<Boolean> groupCloseFuture = this.clientResources.eventLoopGroupProvider().release(eventExecutors, quietPeriod, timeout, timeUnit);
                groupCloseFutures.add(Futures.toCompletionStage(groupCloseFuture));
            }
        }
        return Futures.allOf(groupCloseFutures);
    }

    protected RedisHandshake createHandshake(ConnectionState state) {
        return new RedisHandshake(this.clientOptions.getConfiguredProtocolVersion(), this.clientOptions.isPingBeforeActivateConnection(), state);
    }
}

