/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.ConnectionBuilder;
import de.themoep.connectorplugin.lib.lettuce.core.ConnectionEventTrigger;
import de.themoep.connectorplugin.lib.lettuce.core.event.EventBus;
import de.themoep.connectorplugin.lib.lettuce.core.event.connection.ConnectedEvent;
import de.themoep.connectorplugin.lib.lettuce.core.event.connection.DisconnectedEvent;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandHandler;
import de.themoep.connectorplugin.lib.netty.channel.Channel;
import de.themoep.connectorplugin.lib.netty.channel.ChannelHandlerContext;
import de.themoep.connectorplugin.lib.netty.channel.ChannelInboundHandlerAdapter;
import de.themoep.connectorplugin.lib.netty.channel.group.ChannelGroup;

class ChannelGroupListener
extends ChannelInboundHandlerAdapter {
    private final ChannelGroup channels;
    private final EventBus eventBus;

    public ChannelGroupListener(ChannelGroup channels, EventBus eventBus) {
        this.channels = channels;
        this.eventBus = eventBus;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        CommandHandler commandHandler = ChannelGroupListener.getCommandHandler(ctx);
        String epid = commandHandler.getEndpoint().getId();
        this.eventBus.publish(new ConnectedEvent(ChannelGroupListener.getRedisUri(ctx.channel()), epid, commandHandler.getChannelId(), ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
        this.channels.add(ctx.channel());
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        CommandHandler commandHandler = ChannelGroupListener.getCommandHandler(ctx);
        String epid = commandHandler.getEndpoint().getId();
        this.eventBus.publish(new DisconnectedEvent(ChannelGroupListener.getRedisUri(ctx.channel()), epid, commandHandler.getChannelId(), ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
        this.channels.remove(ctx.channel());
        super.channelInactive(ctx);
    }

    private static String getRedisUri(Channel channel) {
        String redisUri = null;
        if (channel.hasAttr(ConnectionBuilder.REDIS_URI)) {
            redisUri = channel.attr(ConnectionBuilder.REDIS_URI).get();
        }
        return redisUri;
    }

    private static CommandHandler getCommandHandler(ChannelHandlerContext ctx) {
        return ctx.pipeline().get(CommandHandler.class);
    }
}

