/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.RedisChannelWriter;
import de.themoep.connectorplugin.lib.lettuce.core.event.command.CommandFailedEvent;
import de.themoep.connectorplugin.lib.lettuce.core.event.command.CommandListener;
import de.themoep.connectorplugin.lib.lettuce.core.event.command.CommandStartedEvent;
import de.themoep.connectorplugin.lib.lettuce.core.event.command.CommandSucceededEvent;
import de.themoep.connectorplugin.lib.lettuce.core.internal.ExceptionFactory;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandWrapper;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.ConnectionFacade;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.RedisCommand;
import de.themoep.connectorplugin.lib.lettuce.core.resource.ClientResources;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class CommandListenerWriter
implements RedisChannelWriter {
    private final RedisChannelWriter delegate;
    private final CommandListener listener;
    private final Clock clock = Clock.systemDefaultZone();

    public CommandListenerWriter(RedisChannelWriter delegate, List<CommandListener> listeners) {
        this.delegate = delegate;
        this.listener = new CommandListenerMulticaster(new ArrayList<CommandListener>(listeners));
    }

    public static boolean isSupported(List<CommandListener> commandListeners) {
        LettuceAssert.notNull(commandListeners, "CommandListeners must not be null");
        return !commandListeners.isEmpty();
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        long now = this.clock.millis();
        CommandStartedEvent startedEvent = new CommandStartedEvent(command, now);
        this.listener.commandStarted(startedEvent);
        return this.delegate.write(new RedisCommandListenerCommand<Object, Object, Object>(command, this.clock, startedEvent.getContext(), now, this.listener));
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> redisCommands) {
        ArrayList<RedisCommandListenerCommand<Object, Object, Object>> listenedCommands = new ArrayList<RedisCommandListenerCommand<Object, Object, Object>>();
        long now = this.clock.millis();
        for (RedisCommand<Object, Object, Object> redisCommand : redisCommands) {
            CommandStartedEvent startedEvent = new CommandStartedEvent(redisCommand, now);
            this.listener.commandStarted(startedEvent);
            RedisCommandListenerCommand<Object, Object, Object> command = new RedisCommandListenerCommand<Object, Object, Object>(redisCommand, this.clock, startedEvent.getContext(), now, this.listener);
            listenedCommands.add(command);
        }
        return this.delegate.write(listenedCommands);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.delegate.closeAsync();
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public void setConnectionFacade(ConnectionFacade connection) {
        this.delegate.setConnectionFacade(connection);
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.delegate.setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.delegate.flushCommands();
    }

    @Override
    public ClientResources getClientResources() {
        return this.delegate.getClientResources();
    }

    public RedisChannelWriter getDelegate() {
        return this.delegate;
    }

    public static class CommandListenerMulticaster
    implements CommandListener {
        private final List<CommandListener> listeners;

        public CommandListenerMulticaster(List<CommandListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void commandStarted(CommandStartedEvent event) {
            for (CommandListener listener : this.listeners) {
                listener.commandStarted(event);
            }
        }

        @Override
        public void commandSucceeded(CommandSucceededEvent event) {
            for (CommandListener listener : this.listeners) {
                listener.commandSucceeded(event);
            }
        }

        @Override
        public void commandFailed(CommandFailedEvent event) {
            for (CommandListener listener : this.listeners) {
                listener.commandFailed(event);
            }
        }
    }

    private static class RedisCommandListenerCommand<K, V, T>
    extends CommandWrapper<K, V, T> {
        private final Clock clock;
        private final Map<String, Object> context;
        private final long startedAt;
        private final CommandListener listener;

        public RedisCommandListenerCommand(RedisCommand<K, V, T> command, Clock clock, Map<String, Object> context, long startedAt, CommandListener listener) {
            super(command);
            this.clock = clock;
            this.context = context;
            this.startedAt = startedAt;
            this.listener = listener;
        }

        @Override
        public void complete() {
            super.complete();
            if (this.getOutput().hasError()) {
                CommandFailedEvent failedEvent = new CommandFailedEvent(this.command, this.context, ExceptionFactory.createExecutionException(this.getOutput().getError()));
                this.listener.commandFailed(failedEvent);
            } else {
                long now = this.clock.millis();
                CommandSucceededEvent succeededEvent = new CommandSucceededEvent(this.command, this.context, this.startedAt, now);
                this.listener.commandSucceeded(succeededEvent);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
        }

        @Override
        public boolean completeExceptionally(Throwable throwable) {
            boolean state = super.completeExceptionally(throwable);
            CommandFailedEvent failedEvent = new CommandFailedEvent(this.command, this.context, throwable);
            this.listener.commandFailed(failedEvent);
            return state;
        }
    }
}

