/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.RedisURI;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.ProtocolVersion;
import java.util.List;

public class ConnectionState {
    private volatile HandshakeResponse handshakeResponse;
    private volatile String username;
    private volatile char[] password;
    private volatile int db;
    private volatile boolean readOnly;
    private volatile String clientName;

    public void apply(RedisURI redisURI) {
        this.setClientName(redisURI.getClientName());
        this.setUsername(redisURI.getUsername());
        this.setPassword(redisURI.getPassword());
    }

    public ProtocolVersion getNegotiatedProtocolVersion() {
        return this.handshakeResponse != null ? this.handshakeResponse.getNegotiatedProtocolVersion() : null;
    }

    public Long getConnectionId() {
        return this.handshakeResponse != null ? this.handshakeResponse.getConnectionId() : null;
    }

    public String getRedisVersion() {
        return this.handshakeResponse != null ? this.handshakeResponse.getRedisVersion() : null;
    }

    public String getMode() {
        return this.handshakeResponse != null ? this.handshakeResponse.getMode() : null;
    }

    public String getRole() {
        return this.handshakeResponse != null ? this.handshakeResponse.getRole() : null;
    }

    void setHandshakeResponse(HandshakeResponse handshakeResponse) {
        this.handshakeResponse = handshakeResponse;
    }

    protected void setUserNamePassword(List<char[]> args) {
        if (args.isEmpty()) {
            return;
        }
        if (args.size() > 1) {
            this.setUsername(new String(args.get(0)));
            this.setPassword(args.get(1));
        } else {
            this.setUsername(null);
            this.setPassword(args.get(0));
        }
    }

    protected void setUsername(String username) {
        this.username = username;
    }

    String getUsername() {
        return this.username;
    }

    protected void setPassword(char[] password) {
        this.password = password;
    }

    char[] getPassword() {
        return this.password;
    }

    boolean hasPassword() {
        return this.password != null && this.password.length > 0;
    }

    boolean hasUsername() {
        return this.username != null && !this.username.isEmpty();
    }

    protected void setDb(int db) {
        this.db = db;
    }

    int getDb() {
        return this.db;
    }

    protected void setReadOnly(boolean readOnly2) {
        this.readOnly = readOnly2;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setClientName(String clientName) {
        this.clientName = clientName;
    }

    String getClientName() {
        return this.clientName;
    }

    static class HandshakeResponse {
        private final ProtocolVersion negotiatedProtocolVersion;
        private final Long connectionId;
        private final String redisVersion;
        private final String mode;
        private final String role;

        public HandshakeResponse(ProtocolVersion negotiatedProtocolVersion, Long connectionId, String redisVersion, String mode, String role) {
            this.negotiatedProtocolVersion = negotiatedProtocolVersion;
            this.connectionId = connectionId;
            this.redisVersion = redisVersion;
            this.role = role;
            this.mode = mode;
        }

        public ProtocolVersion getNegotiatedProtocolVersion() {
            return this.negotiatedProtocolVersion;
        }

        public Long getConnectionId() {
            return this.connectionId;
        }

        public String getRedisVersion() {
            return this.redisVersion;
        }

        public String getMode() {
            return this.mode;
        }

        public String getRole() {
            return this.role;
        }
    }
}

