/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.GeoCoordinates;
import de.themoep.connectorplugin.lib.lettuce.core.Value;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class GeoValue<V>
extends Value<V> {
    private final GeoCoordinates coordinates;

    protected GeoValue() {
        super(null);
        this.coordinates = null;
    }

    private GeoValue(GeoCoordinates coordinates, V value) {
        super(value);
        this.coordinates = coordinates;
    }

    public static <T extends V, V> Value<V> from(GeoCoordinates coordinates, Optional<T> optional) {
        LettuceAssert.notNull(optional, "Optional must not be null");
        if (optional.isPresent()) {
            LettuceAssert.notNull((Object)coordinates, "GeoCoordinates must not be null");
            return new GeoValue<T>(coordinates, optional.get());
        }
        return Value.empty();
    }

    public static <T extends V, V> Value<V> fromNullable(GeoCoordinates coordinates, T value) {
        if (value == null) {
            return GeoValue.empty();
        }
        LettuceAssert.notNull((Object)coordinates, "GeoCoordinates must not be null");
        return new GeoValue<T>(coordinates, value);
    }

    public static <T extends V, V> GeoValue<V> just(double longitude, double latitude, T value) {
        return new GeoValue<T>(new GeoCoordinates(longitude, latitude), value);
    }

    public static <T extends V, V> GeoValue<V> just(GeoCoordinates coordinates, T value) {
        LettuceAssert.notNull((Object)coordinates, "GeoCoordinates must not be null");
        return new GeoValue<T>(coordinates, value);
    }

    public GeoCoordinates getCoordinates() {
        return this.coordinates;
    }

    public double getLongitude() {
        if (this.coordinates == null) {
            throw new NoSuchElementException();
        }
        return this.coordinates.getX().doubleValue();
    }

    public double getLatitude() {
        if (this.coordinates == null) {
            throw new NoSuchElementException();
        }
        return this.coordinates.getY().doubleValue();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoValue geoValue = (GeoValue)o;
        return Objects.equals(this.coordinates, geoValue.coordinates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.coordinates);
    }

    @Override
    public String toString() {
        return this.hasValue() ? String.format("GeoValue[%s, %s]", this.coordinates, this.getValue()) : String.format("GeoValue[%s].empty", this.coordinates);
    }

    @Override
    public <R> GeoValue<R> map(Function<? super V, ? extends R> mapper) {
        LettuceAssert.notNull(mapper, "Mapper function must not be null");
        if (this.hasValue()) {
            return new GeoValue<R>(this.coordinates, mapper.apply(this.getValue()));
        }
        return this;
    }

    public GeoValue<V> mapCoordinates(Function<? super GeoCoordinates, ? extends GeoCoordinates> mapper) {
        LettuceAssert.notNull(mapper, "Mapper function must not be null");
        if (this.hasValue()) {
            return new GeoValue(mapper.apply(this.coordinates), this.getValue());
        }
        return this;
    }
}

