/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.CompositeArgument;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandArgs;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandType;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;

public class GetExArgs
implements CompositeArgument {
    private Long ex;
    private Long exAt;
    private Long px;
    private Long pxAt;
    private boolean persist = false;

    public GetExArgs ex(long timeout) {
        this.ex = timeout;
        return this;
    }

    public GetExArgs ex(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        this.ex = timeout.toMillis() / 1000L;
        return this;
    }

    public GetExArgs exAt(long timestamp) {
        this.exAt = timestamp;
        return this;
    }

    public GetExArgs exAt(Date timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.exAt(timestamp.getTime() / 1000L);
    }

    public GetExArgs exAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.exAt(timestamp.toEpochMilli() / 1000L);
    }

    public GetExArgs px(long timeout) {
        this.px = timeout;
        return this;
    }

    public GetExArgs px(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        this.px = timeout.toMillis();
        return this;
    }

    public GetExArgs pxAt(long timestamp) {
        this.pxAt = timestamp;
        return this;
    }

    public GetExArgs pxAt(Date timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pxAt(timestamp.getTime());
    }

    public GetExArgs pxAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pxAt(timestamp.toEpochMilli());
    }

    public GetExArgs persist() {
        this.persist = true;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.ex != null) {
            args.add("EX").add(this.ex);
        }
        if (this.exAt != null) {
            args.add("EXAT").add(this.exAt);
        }
        if (this.px != null) {
            args.add("PX").add(this.px);
        }
        if (this.pxAt != null) {
            args.add("PXAT").add(this.pxAt);
        }
        if (this.persist) {
            args.add(CommandType.PERSIST);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static GetExArgs ex(long timeout) {
            return new GetExArgs().ex(timeout);
        }

        public static GetExArgs ex(Duration timeout) {
            return new GetExArgs().ex(timeout);
        }

        public static GetExArgs exAt(long timestamp) {
            return new GetExArgs().exAt(timestamp);
        }

        public static GetExArgs exAt(Date timestamp) {
            return new GetExArgs().exAt(timestamp);
        }

        public static GetExArgs exAt(Instant timestamp) {
            return new GetExArgs().exAt(timestamp);
        }

        public static GetExArgs px(long timeout) {
            return new GetExArgs().px(timeout);
        }

        public static GetExArgs px(Duration timeout) {
            return new GetExArgs().px(timeout);
        }

        public static GetExArgs pxAt(long timestamp) {
            return new GetExArgs().pxAt(timestamp);
        }

        public static GetExArgs pxAt(Date timestamp) {
            return new GetExArgs().pxAt(timestamp);
        }

        public static GetExArgs pxAt(Instant timestamp) {
            return new GetExArgs().pxAt(timestamp);
        }

        public static GetExArgs persist() {
            return new GetExArgs().persist();
        }
    }
}

