/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.CompositeArgument;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandArgs;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandKeyword;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandType;

public class KillArgs
implements CompositeArgument {
    private Boolean skipme;
    private String addr;
    private String laddr;
    private Long id;
    private Type type;
    private String username;

    public KillArgs skipme() {
        return this.skipme(true);
    }

    public KillArgs skipme(boolean state) {
        this.skipme = state;
        return this;
    }

    public KillArgs addr(String addr) {
        LettuceAssert.notNull((Object)addr, "Client address must not be null");
        this.addr = addr;
        return this;
    }

    public KillArgs laddr(String laddr) {
        LettuceAssert.notNull((Object)laddr, "Local client address must not be null");
        this.laddr = laddr;
        return this;
    }

    public KillArgs id(long id) {
        this.id = id;
        return this;
    }

    public KillArgs type(Type type) {
        LettuceAssert.notNull((Object)type, "Type must not be null");
        this.type = type;
        return this;
    }

    public KillArgs user(String username) {
        LettuceAssert.notNull((Object)username, "UserName must not be null");
        this.username = username;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.skipme != null) {
            args.add(CommandKeyword.SKIPME).add(this.skipme != false ? "YES" : "NO");
        }
        if (this.id != null) {
            args.add(CommandKeyword.ID).add(this.id);
        }
        if (this.addr != null) {
            args.add(CommandKeyword.ADDR).add(this.addr);
        }
        if (this.laddr != null) {
            args.add("LADDR").add(this.laddr);
        }
        if (this.type != null) {
            args.add(CommandType.TYPE).add(this.type.name().toLowerCase());
        }
        if (this.username != null) {
            args.add("USER").add(this.username);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static KillArgs skipme() {
            return new KillArgs().skipme();
        }

        public static KillArgs addr(String addr) {
            return new KillArgs().addr(addr);
        }

        public static KillArgs laddr(String laddr) {
            return new KillArgs().laddr(laddr);
        }

        public static KillArgs id(long id) {
            return new KillArgs().id(id);
        }

        public static KillArgs typePubsub() {
            return new KillArgs().type(Type.PUBSUB);
        }

        public static KillArgs typeNormal() {
            return new KillArgs().type(Type.NORMAL);
        }

        public static KillArgs typeMaster() {
            return new KillArgs().type(Type.MASTER);
        }

        public static KillArgs typeSlave() {
            return new KillArgs().type(Type.SLAVE);
        }

        public static KillArgs user(String username) {
            return new KillArgs().user(username);
        }
    }

    private static enum Type {
        NORMAL,
        MASTER,
        SLAVE,
        PUBSUB;

    }
}

