/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.CompositeArgument;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandArgs;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandKeyword;

public class LPosArgs
implements CompositeArgument {
    private Long rank;
    private Long maxlen;

    public LPosArgs maxlen(long maxlen) {
        LettuceAssert.isTrue(maxlen > 0L, "Maxlen must be greater 0");
        this.maxlen = maxlen;
        return this;
    }

    public LPosArgs rank(long rank) {
        this.rank = rank;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.maxlen != null) {
            args.add(CommandKeyword.MAXLEN);
            args.add(this.maxlen);
        }
        if (this.rank != null) {
            args.add("RANK");
            args.add(this.rank);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static LPosArgs empty() {
            return new LPosArgs();
        }

        public static LPosArgs maxlen(long count) {
            return new LPosArgs().maxlen(count);
        }

        public static LPosArgs rank(long rank) {
            return new LPosArgs().rank(rank);
        }
    }
}

