/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceFactories;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLogger;
import de.themoep.connectorplugin.lib.netty.util.internal.logging.InternalLoggerFactory;
import de.themoep.connectorplugin.lib.reactivestreams.Subscription;
import de.themoep.connectorplugin.lib.reactor.core.Exceptions;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Hooks;
import de.themoep.connectorplugin.lib.reactor.util.annotation.Nullable;
import de.themoep.connectorplugin.lib.reactor.util.concurrent.Queues;
import de.themoep.connectorplugin.lib.reactor.util.context.Context;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Supplier;

class Operators {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(Operators.class);
    private static final String KEY_ON_OPERATOR_ERROR = "de.themoep.connectorplugin.lib.reactor.onOperatorError.local";
    private static final Field onOperatorErrorHook = Operators.findOnOperatorErrorHookField();
    private static final Supplier<Queue<Object>> queueSupplier = Operators.getQueueSupplier();

    Operators() {
    }

    private static Field findOnOperatorErrorHookField() {
        try {
            return AccessController.doPrivileged(() -> {
                Field field = Hooks.class.getDeclaredField("onOperatorErrorHook");
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field;
            });
        }
        catch (PrivilegedActionException e) {
            return null;
        }
    }

    private static Supplier<Queue<Object>> getQueueSupplier() {
        try {
            return AccessController.doPrivileged(() -> {
                Method unbounded = Queues.class.getMethod("unbounded", new Class[0]);
                return (Supplier)unbounded.invoke(Queues.class, new Object[0]);
            });
        }
        catch (PrivilegedActionException e) {
            return LettuceFactories::newSpScQueue;
        }
    }

    static long addCap(long a, long b) {
        long res = a + b;
        if (res < 0L) {
            return Long.MAX_VALUE;
        }
        return res;
    }

    public static <T> boolean request(AtomicLongFieldUpdater<T> updater, T instance, long toAdd) {
        if (Operators.validate(toAdd)) {
            Operators.addCap(updater, instance, toAdd);
            return true;
        }
        return false;
    }

    static <T> long addCap(AtomicLongFieldUpdater<T> updater, T instance, long toAdd) {
        long u;
        long r;
        do {
            if ((r = updater.get(instance)) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!updater.compareAndSet(instance, r, u = Operators.addCap(r, toAdd)));
        return r;
    }

    static boolean validate(long n) {
        if (n <= 0L) {
            Operators.reportBadRequest(n);
            return false;
        }
        return true;
    }

    static void reportBadRequest(long n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Negative request", Exceptions.nullOrNegativeRequestException(n));
        }
    }

    static IllegalArgumentException nullOrNegativeRequestException(long elements) {
        return new IllegalArgumentException("Spec. Rule 3.9 - Cannot request a non strictly positive number: " + elements);
    }

    static Throwable onOperatorError(@Nullable Subscription subscription, Throwable error, @Nullable Object dataSignal, Context context) {
        Exceptions.throwIfFatal(error);
        if (subscription != null) {
            subscription.cancel();
        }
        Throwable t = Exceptions.unwrap(error);
        BiFunction<? super Throwable, Object, ? extends Throwable> hook = context.getOrDefault(KEY_ON_OPERATOR_ERROR, null);
        if (hook == null && onOperatorErrorHook != null) {
            hook = Operators.getOnOperatorErrorHook();
        }
        if (hook == null) {
            if (dataSignal != null && dataSignal != t && dataSignal instanceof Throwable) {
                t = Exceptions.addSuppressed(t, (Throwable)dataSignal);
            }
            return t;
        }
        return hook.apply(error, dataSignal);
    }

    static <T> Queue<T> newQueue() {
        return queueSupplier.get();
    }

    private static BiFunction<? super Throwable, Object, ? extends Throwable> getOnOperatorErrorHook() {
        try {
            return (BiFunction)onOperatorErrorHook.get(Hooks.class);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }
}

