/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;

public class ScanCursor {
    public static final ScanCursor FINISHED = new ImmutableScanCursor("0", true);
    public static final ScanCursor INITIAL = new ImmutableScanCursor("0", false);
    private String cursor;
    private boolean finished;

    public ScanCursor() {
    }

    public ScanCursor(String cursor, boolean finished) {
        this.cursor = cursor;
        this.finished = finished;
    }

    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        LettuceAssert.notEmpty((CharSequence)cursor, "Cursor must not be empty");
        this.cursor = cursor;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public static ScanCursor of(String cursor) {
        ScanCursor scanCursor = new ScanCursor();
        scanCursor.setCursor(cursor);
        return scanCursor;
    }

    private static class ImmutableScanCursor
    extends ScanCursor {
        public ImmutableScanCursor(String cursor, boolean finished) {
            super(cursor, finished);
        }

        @Override
        public void setCursor(String cursor) {
            throw new UnsupportedOperationException("setCursor not supported on " + this.getClass().getSimpleName());
        }

        @Override
        public void setFinished(boolean finished) {
            throw new UnsupportedOperationException("setFinished not supported on " + this.getClass().getSimpleName());
        }
    }
}

