/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.KeyScanCursor;
import de.themoep.connectorplugin.lib.lettuce.core.KeyValue;
import de.themoep.connectorplugin.lib.lettuce.core.ScanArgs;
import de.themoep.connectorplugin.lib.lettuce.core.ScanCursor;
import de.themoep.connectorplugin.lib.lettuce.core.ScoredValue;
import de.themoep.connectorplugin.lib.lettuce.core.ScoredValueScanCursor;
import de.themoep.connectorplugin.lib.lettuce.core.ValueScanCursor;
import de.themoep.connectorplugin.lib.lettuce.core.api.reactive.RedisHashReactiveCommands;
import de.themoep.connectorplugin.lib.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import de.themoep.connectorplugin.lib.lettuce.core.api.reactive.RedisSetReactiveCommands;
import de.themoep.connectorplugin.lib.lettuce.core.api.reactive.RedisSortedSetReactiveCommands;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.reactivestreams.Publisher;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Flux;
import de.themoep.connectorplugin.lib.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public abstract class ScanStream {
    private ScanStream() {
    }

    public static <K, V> Flux<K> scan(RedisKeyReactiveCommands<K, V> commands) {
        return ScanStream.scan(commands, Optional.empty());
    }

    public static <K, V> Flux<K> scan(RedisKeyReactiveCommands<K, V> commands, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanStream.scan(commands, Optional.of(scanArgs));
    }

    private static <K, V> Flux<K> scan(RedisKeyReactiveCommands<K, V> commands, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisKeyCommands must not be null");
        return scanArgs.map(commands::scan).orElseGet(commands::scan).expand(c -> !c.isFinished() ? (Publisher)scanArgs.map(it -> commands.scan((ScanCursor)c, (ScanArgs)it)).orElseGet(() -> commands.scan((ScanCursor)c)) : Mono.empty()).flatMapIterable(KeyScanCursor::getKeys);
    }

    public static <K, V> Flux<KeyValue<K, V>> hscan(RedisHashReactiveCommands<K, V> commands, K key) {
        return ScanStream.hscan(commands, key, Optional.empty());
    }

    public static <K, V> Flux<KeyValue<K, V>> hscan(RedisHashReactiveCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanStream.hscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> Flux<KeyValue<K, V>> hscan(RedisHashReactiveCommands<K, V> commands, K key, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisHashReactiveCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        return scanArgs.map(it -> commands.hscan(key, (ScanArgs)it)).orElseGet(() -> commands.hscan(key)).expand(c -> !c.isFinished() ? (Publisher)scanArgs.map(it -> commands.hscan(key, (ScanCursor)c, (ScanArgs)it)).orElseGet(() -> commands.hscan(key, (ScanCursor)c)) : Mono.empty()).flatMapIterable(c -> {
            ArrayList list = new ArrayList(c.getMap().size());
            for (Map.Entry kvEntry : c.getMap().entrySet()) {
                list.add(KeyValue.fromNullable(kvEntry.getKey(), kvEntry.getValue()));
            }
            return list;
        });
    }

    public static <K, V> Flux<V> sscan(RedisSetReactiveCommands<K, V> commands, K key) {
        return ScanStream.sscan(commands, key, Optional.empty());
    }

    public static <K, V> Flux<V> sscan(RedisSetReactiveCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanStream.sscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> Flux<V> sscan(RedisSetReactiveCommands<K, V> commands, K key, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisSetReactiveCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        return scanArgs.map(it -> commands.sscan(key, (ScanArgs)it)).orElseGet(() -> commands.sscan(key)).expand(c -> !c.isFinished() ? (Publisher)scanArgs.map(it -> commands.sscan(key, (ScanCursor)c, (ScanArgs)it)).orElseGet(() -> commands.sscan(key, (ScanCursor)c)) : Mono.empty()).flatMapIterable(ValueScanCursor::getValues);
    }

    public static <K, V> Flux<ScoredValue<V>> zscan(RedisSortedSetReactiveCommands<K, V> commands, K key) {
        return ScanStream.zscan(commands, key, Optional.empty());
    }

    public static <K, V> Flux<ScoredValue<V>> zscan(RedisSortedSetReactiveCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanStream.zscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> Flux<ScoredValue<V>> zscan(RedisSortedSetReactiveCommands<K, V> commands, K key, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisSortedSetReactiveCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        return scanArgs.map(it -> commands.zscan(key, (ScanArgs)it)).orElseGet(() -> commands.zscan(key)).expand(c -> !c.isFinished() ? (Publisher)scanArgs.map(it -> commands.zscan(key, (ScanCursor)c, (ScanArgs)it)).orElseGet(() -> commands.zscan(key, (ScanCursor)c)) : Mono.empty()).flatMapIterable(ScoredValueScanCursor::getValues);
    }
}

