/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.CompositeArgument;
import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.CommandArgs;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StrAlgoArgs
implements CompositeArgument {
    private boolean justLen;
    private int minMatchLen;
    private boolean withMatchLen;
    private boolean withIdx;
    private By by = By.STRINGS;
    private String[] keys;
    private Charset charset = StandardCharsets.UTF_8;

    public StrAlgoArgs minMatchLen(int minMatchLen) {
        this.minMatchLen = minMatchLen;
        return this;
    }

    public StrAlgoArgs justLen() {
        this.justLen = true;
        return this;
    }

    public StrAlgoArgs withMatchLen() {
        this.withMatchLen = true;
        return this;
    }

    public StrAlgoArgs withIdx() {
        this.withIdx = true;
        return this;
    }

    public StrAlgoArgs by(By by, String ... keys) {
        LettuceAssert.notNull((Object)by, "By-selector must not be null");
        LettuceAssert.notEmpty((Object[])keys, "Keys must not be empty");
        this.by = by;
        this.keys = keys;
        return this;
    }

    public boolean isWithIdx() {
        return this.withIdx;
    }

    public StrAlgoArgs charset(Charset charset) {
        LettuceAssert.notNull((Object)charset, "Charset must not be null");
        this.charset = charset;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        args.add("LCS");
        args.add(this.by.name());
        for (String key : this.keys) {
            if (this.by == By.STRINGS) {
                args.add(key.getBytes(this.charset));
                continue;
            }
            args.add(key);
        }
        if (this.justLen) {
            args.add("LEN");
        }
        if (this.withIdx) {
            args.add("IDX");
        }
        if (this.minMatchLen > 0) {
            args.add("MINMATCHLEN");
            args.add(this.minMatchLen);
        }
        if (this.withMatchLen) {
            args.add("WITHMATCHLEN");
        }
    }

    public static enum By {
        STRINGS,
        KEYS;

    }

    public static class Builder {
        private Builder() {
        }

        public static StrAlgoArgs keys(String ... keys) {
            return new StrAlgoArgs().by(By.KEYS, keys);
        }

        public static StrAlgoArgs strings(String ... strings) {
            return new StrAlgoArgs().by(By.STRINGS, strings);
        }

        public static StrAlgoArgs strings(Charset charset, String ... strings) {
            return new StrAlgoArgs().by(By.STRINGS, strings).charset(charset);
        }
    }
}

