/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.connectorplugin.lib.lettuce.core;

import de.themoep.connectorplugin.lib.lettuce.core.internal.LettuceAssert;
import de.themoep.connectorplugin.lib.lettuce.core.protocol.RedisCommand;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class TimeoutOptions
implements Serializable {
    public static final boolean DEFAULT_TIMEOUT_COMMANDS = false;
    private final boolean timeoutCommands;
    private final boolean applyConnectionTimeout;
    private final TimeoutSource source;

    private TimeoutOptions(boolean timeoutCommands, boolean applyConnectionTimeout, TimeoutSource source) {
        this.timeoutCommands = timeoutCommands;
        this.applyConnectionTimeout = applyConnectionTimeout;
        this.source = source;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TimeoutOptions create() {
        return TimeoutOptions.builder().build();
    }

    public static TimeoutOptions enabled() {
        return TimeoutOptions.builder().timeoutCommands().connectionTimeout().build();
    }

    public static TimeoutOptions enabled(Duration timeout) {
        return TimeoutOptions.builder().timeoutCommands().fixedTimeout(timeout).build();
    }

    public boolean isTimeoutCommands() {
        return this.timeoutCommands;
    }

    public boolean isApplyConnectionTimeout() {
        return this.applyConnectionTimeout;
    }

    public TimeoutSource getSource() {
        return this.source;
    }

    public static abstract class TimeoutSource {
        public abstract long getTimeout(RedisCommand<?, ?, ?> var1);

        public TimeUnit getTimeUnit() {
            return TimeUnit.MILLISECONDS;
        }
    }

    private static class FixedTimeoutSource
    extends TimeoutSource {
        private final long timeout;
        private final TimeUnit timeUnit;

        FixedTimeoutSource(long timeout, TimeUnit timeUnit) {
            this.timeout = timeout;
            this.timeUnit = timeUnit;
        }

        @Override
        public long getTimeout(RedisCommand<?, ?, ?> command) {
            return this.timeout;
        }

        @Override
        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }
    }

    private static class DefaultTimeoutSource
    extends TimeoutSource {
        private final long timeout = -1L;

        private DefaultTimeoutSource() {
        }

        @Override
        public long getTimeout(RedisCommand<?, ?, ?> command) {
            return -1L;
        }
    }

    public static class Builder {
        private boolean timeoutCommands = false;
        private boolean applyConnectionTimeout = false;
        private TimeoutSource source;

        public Builder timeoutCommands() {
            return this.timeoutCommands(true);
        }

        public Builder timeoutCommands(boolean enabled) {
            this.timeoutCommands = enabled;
            return this;
        }

        public Builder fixedTimeout(Duration duration) {
            LettuceAssert.notNull((Object)duration, "Duration must not be null");
            return this.timeoutSource(new FixedTimeoutSource(duration.toNanos(), TimeUnit.NANOSECONDS));
        }

        public Builder connectionTimeout() {
            return this.timeoutSource(new DefaultTimeoutSource());
        }

        public Builder timeoutSource(TimeoutSource source) {
            LettuceAssert.notNull((Object)source, "TimeoutSource must not be null");
            this.timeoutCommands(true);
            this.applyConnectionTimeout = source instanceof DefaultTimeoutSource;
            this.source = source;
            return this;
        }

        public TimeoutOptions build() {
            if (this.timeoutCommands && this.source == null) {
                throw new IllegalStateException("TimeoutSource is required for enabled timeouts");
            }
            return new TimeoutOptions(this.timeoutCommands, this.applyConnectionTimeout, this.source);
        }
    }
}

